/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.CollectionHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class NetworkHelper {
    private static final String[] HTML_ESCAPE_FINDS = new String[]{"<", ">", "\"", "&", "'"};
    private static final String[] HTML_ESCAPE_REPLACES = new String[]{"&lt;", "&gt;", "&#034;", "&amp;", "&#039;"};
    private static final String[] HTML_COMMON_ENTITIES_FINDS = new String[]{"&nbsp;", "&quot;", "&rdquo;", "&ldquo;", "&rsquo;", "&lsquo;", "&amp;"};
    private static final String[] HTML_COMMON_ENTITIES_REPLACES = new String[]{" ", "\"", "\"", "\"", "'", "'", "&"};
    private static final String[] HTML_LINEBREAK_FINDS = new String[]{"\r\n", "\n", "\r"};
    private static final String[] HTML_LINEBREAK_REPLACES = new String[]{"<br/>", "<br/>", "<br/>"};
    private static final Pattern HTML5_EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,253}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,253}[a-zA-Z0-9])?)*$");
    public static final int MAXIMUM_EMAIL_ADDRESS_LENGTH = 254;

    public static boolean isWebUrl(String possibleUrl) {
        if (StringHelper.isNonEmpty(possibleUrl)) {
            String lowercase = possibleUrl.toLowerCase();
            return lowercase.startsWith("http:") || lowercase.startsWith("https:");
        }
        return false;
    }

    public static int convertIpv4ToInt(String ip) {
        if (StringHelper.isNonEmpty(ip)) {
            int fourthOctet;
            StringTokenizer tokens = new StringTokenizer(ip, ".");
            int firstOctet = NumberHelper.boundInteger(NumberHelper.parseInt(tokens.nextToken()), 0, 255);
            int secondOctet = NumberHelper.boundInteger(NumberHelper.parseInt(tokens.nextToken()), 0, 255);
            int thirdOctet = NumberHelper.boundInteger(NumberHelper.parseInt(tokens.nextToken()), 0, 255);
            int result = fourthOctet = NumberHelper.boundInteger(NumberHelper.parseInt(tokens.nextToken()), 0, 255);
            result += thirdOctet << 8;
            result += secondOctet << 16;
            return result += firstOctet << 24;
        }
        return 0;
    }

    public static String convertIntToIpv4(int ip) {
        int work = ip;
        int firstOctet = work >> 24 & 0xFF;
        int secondOctet = (work &= 0xFFFFFF) >> 16 & 0xFF;
        int thirdOctet = (work &= 0xFFFF) >> 8 & 0xFF;
        int fourthOctet = (work &= 0xFF) & 0xFF;
        return String.valueOf(firstOctet) + "." + secondOctet + "." + thirdOctet + "." + fourthOctet;
    }

    public static String decodeCommonEntities(String inputString) {
        return StringHelper.replaceSubstrings(inputString, HTML_COMMON_ENTITIES_FINDS, HTML_COMMON_ENTITIES_REPLACES);
    }

    public static String escapeDoubleQuotesForHtml(String inputString) {
        return StringHelper.replaceSubstrings(inputString, "\"", "&quot;");
    }

    public static String render(String untrustedString) {
        return NetworkHelper.escapeStringForHtml(untrustedString);
    }

    public static String escapeStringForHtml(String untrustedString) {
        return StringHelper.replaceSubstrings(untrustedString, HTML_ESCAPE_FINDS, HTML_ESCAPE_REPLACES);
    }

    public static String escapeNonbreakingStringForHtml(String untrustedString) {
        return NetworkHelper.escapeStringForHtml(untrustedString).replaceAll("\\s", "&nbsp;");
    }

    public static String stripHtmlTags(String inputString) {
        return inputString == null ? "" : inputString.replaceAll("\\<(.|\\n|\\r)*?\\>", "");
    }

    public static String encodeUrl(String inputUrl) {
        if (StringHelper.isNonEmpty(inputUrl)) {
            try {
                return URLEncoder.encode(inputUrl, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return inputUrl;
    }

    public static String decodeUrl(String inputUrl) throws IllegalArgumentException {
        if (StringHelper.isNonEmpty(inputUrl)) {
            try {
                return URLDecoder.decode(inputUrl, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return inputUrl;
    }

    public static String formatUrl(String inputUrl) {
        if (inputUrl != null) {
            if (inputUrl.length() > 0) {
                StringBuilder newUrl = new StringBuilder(inputUrl.length() + 8);
                newUrl.append(inputUrl);
                if (!inputUrl.startsWith("http://") && !inputUrl.startsWith("ftp://")) {
                    newUrl.insert(0, "http://");
                }
                if (newUrl.toString().substring(7).indexOf(47) == -1) {
                    newUrl.append("/");
                }
                return newUrl.toString();
            }
            return inputUrl;
        }
        return "";
    }

    public static String getDomainFromURL(String url) {
        int doubleSlashPos;
        if (StringHelper.isNonEmpty(url) && (doubleSlashPos = url.indexOf("//")) >= 0) {
            try {
                String sansProtocol = url.substring(doubleSlashPos + 2);
                int nextSlashPos = sansProtocol.indexOf(47);
                if (nextSlashPos > 0) {
                    return sansProtocol.substring(0, nextSlashPos);
                }
                return sansProtocol;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return "";
    }

    public static String convertSpacesToNonBreaking(String source) {
        if (source == null) {
            return null;
        }
        return StringHelper.replaceSubstrings(source, " ", "&nbsp;");
    }

    public static String convertPlaintextLinebreaksToHtml(String source) {
        return StringHelper.replaceSubstrings(source, HTML_LINEBREAK_FINDS, HTML_LINEBREAK_REPLACES);
    }

    public static boolean validateHTML5EmailAddress(String email) {
        if (email == null) {
            return false;
        }
        return HTML5_EMAIL_PATTERN.matcher(email).matches();
    }

    public static String getQueryString(String[] paramKeys, String[] paramValues) {
        StringBuilder sb = new StringBuilder();
        if (CollectionHelper.isNonEmpty(paramKeys) && CollectionHelper.isNonEmpty(paramValues)) {
            int i = 0;
            while (i < paramKeys.length && i < paramValues.length) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(paramKeys[i]);
                sb.append("=");
                sb.append(NetworkHelper.encodeUrl(paramValues[i]));
                ++i;
            }
        }
        return sb.toString();
    }

    private NetworkHelper() {
    }
}

