/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public final class NumberHelper {
    public static final Random random = new Random(System.currentTimeMillis());

    public static final int randomInt() {
        return random.nextInt();
    }

    public static final int randomInt(int max) {
        return random.nextInt(max);
    }

    public static final long randomLong() {
        return random.nextLong();
    }

    public static final float randomFloat() {
        return random.nextFloat();
    }

    public static final double randomDouble() {
        return random.nextDouble();
    }

    public static int boundInteger(int toBound, int minimum, int maximum) {
        int result = toBound;
        if (result < minimum) {
            result = minimum;
        }
        if (result > maximum) {
            result = maximum;
        }
        return result;
    }

    public static long boundLong(long toBound, long minimum, long maximum) {
        long result = toBound;
        if (result < minimum) {
            result = minimum;
        }
        if (result > maximum) {
            result = maximum;
        }
        return result;
    }

    public static int parseInt(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        int num = 0;
        int sign = -1;
        int len = string.length();
        if (len == 0) {
            return defaultValue;
        }
        char ch = string.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                return defaultValue;
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                return defaultValue;
            }
            num = -d;
        }
        int max = sign == -1 ? -2147483647 : Integer.MIN_VALUE;
        int multmax = max / 10;
        int i = 1;
        while (i < len) {
            int d;
            if ((d = string.charAt(i++) - 48) < 0 || d > 9) {
                return defaultValue;
            }
            if (num < multmax) {
                return defaultValue;
            }
            if ((num *= 10) < max + d) {
                return defaultValue;
            }
            num -= d;
        }
        return sign * num;
    }

    public static int parseInt(String string) {
        return NumberHelper.parseInt(string, 0);
    }

    public static int parseInt(String string, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(NumberHelper.parseInt(string, defaultValue), minimum, maximum);
    }

    public static long parseLong(String string, long defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        long num = 0L;
        int sign = -1;
        int len = string.length();
        if (len == 0) {
            return defaultValue;
        }
        char ch = string.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                return defaultValue;
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                return defaultValue;
            }
            num = -d;
        }
        long max = sign == -1 ? -9223372036854775807L : Long.MIN_VALUE;
        long multmax = max / 10L;
        int i = 1;
        while (i < len) {
            int d;
            if ((d = string.charAt(i++) - 48) < 0 || d > 9) {
                return defaultValue;
            }
            if (num < multmax) {
                return defaultValue;
            }
            if ((num *= 10L) < max + (long)d) {
                return defaultValue;
            }
            num -= (long)d;
        }
        return (long)sign * num;
    }

    public static long parseLong(String string) {
        return NumberHelper.parseLong(string, 0L);
    }

    public static long parseLong(String string, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(NumberHelper.parseLong(string, defaultValue), minimum, maximum);
    }

    public static boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static int parseIntPermissive(String numStr, int defaultValue) {
        if (numStr != null) {
            try {
                return (int)Double.parseDouble(numStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static float parseFloat(String numStr, float defaultValue) {
        if (numStr != null) {
            try {
                return Float.parseFloat(numStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        System.out.println(NumberHelper.parseInt("1234567", 0));
        System.out.println(NumberHelper.parseInt("-1234567", 0));
        System.out.println(NumberHelper.parseInt("234567890", 0));
        System.out.println(NumberHelper.parseInt("-010", 0));
        System.out.println(NumberHelper.parseInt("010", 0));
        System.out.println(NumberHelper.parseInt("1000000", 0));
        System.out.println(NumberHelper.parseInt("-foo", 0));
        System.out.println(NumberHelper.parseInt("-", 0));
        System.out.println(NumberHelper.parseInt("foo", 0));
        int foo = Integer.MIN_VALUE;
        System.out.println(String.valueOf(foo) + "; " + Integer.parseInt("" + foo) + "; " + NumberHelper.parseInt("" + foo));
        System.out.println(String.valueOf(++foo) + "; " + Integer.parseInt("" + foo) + "; " + NumberHelper.parseInt("" + foo));
        foo = Integer.MAX_VALUE;
        System.out.println(String.valueOf(foo) + "; " + Integer.parseInt("" + foo) + "; " + NumberHelper.parseInt("" + foo));
        System.out.println(String.valueOf(--foo) + "; " + Integer.parseInt("" + foo) + "; " + NumberHelper.parseInt("" + foo));
        System.out.println(String.valueOf(foo) + "; " + NumberHelper.parseInt("2147483648"));
    }

    public static double round(double value, int decimalPlaces) {
        if (decimalPlaces < 0) {
            throw new IllegalArgumentException("decimalPlaces can not be less than 0: " + decimalPlaces);
        }
        return new BigDecimal(value).setScale(decimalPlaces, 4).doubleValue();
    }

    public static int getPageStartOffset(int page, int pageSize) {
        return NumberHelper.getPageStartOffset(page, pageSize, -1);
    }

    public static int getPageStartOffset(int page, int pageSize, int maximum) {
        int boundedPage = NumberHelper.boundInteger(page, 1, Integer.MAX_VALUE);
        int offset = (boundedPage - 1) * pageSize;
        if (maximum > 0 && offset > maximum) {
            offset = 0;
        }
        return offset;
    }

    public static int getPageEndOffset(int page, int pageSize, int maximum) {
        int offset = NumberHelper.getPageStartOffset(page, pageSize, maximum) + pageSize;
        if (offset > maximum) {
            offset = maximum;
        }
        return offset;
    }

    public static int getPageCount(int items, int pageSize) {
        return items / pageSize + (items % pageSize > 0 ? 1 : 0);
    }

    public static Double getMedian(List<Integer> values) {
        if (values != null && values.size() > 0) {
            Collections.sort(values);
            if (values.size() % 2 == 1) {
                return (double)values.get((values.size() + 1) / 2 - 1);
            }
            int value1 = values.get(values.size() / 2 - 1);
            int value2 = values.get(values.size() / 2 + 1 - 1);
            return (double)(value1 + value2) / 2.0;
        }
        return null;
    }

    public static boolean almostEquals(double a, double b) {
        return NumberHelper.almostEquals(a, b, 1.0E-7);
    }

    public static boolean almostEquals(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    private NumberHelper() {
    }
}

