/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;

public final class PhoneHelper {
    public static String formatStandard(String phoneNumber) {
        if (StringHelper.isEmpty(phoneNumber)) {
            return "";
        }
        String numbersOnly = StringHelper.stripNonNumeric(phoneNumber);
        long numbers = 0L;
        try {
            numbers = Long.parseLong(numbersOnly);
            while (numbers >= 10000000000L) {
                numbers /= 10L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder(12);
        buffer.append(StringHelper.padZero((int)(numbers / 10000000L), 3));
        buffer.append('-');
        buffer.append(StringHelper.padZero((int)((numbers %= 10000000L) / 10000L), 3));
        buffer.append('-');
        buffer.append(StringHelper.padZero((int)(numbers %= 10000L), 4));
        return buffer.toString();
    }

    public static String formatParen(String phoneNumber) {
        if (StringHelper.isEmpty(phoneNumber)) {
            return "";
        }
        String numbersOnly = StringHelper.stripNonNumeric(phoneNumber);
        long numbers = 0L;
        try {
            numbers = Long.parseLong(numbersOnly);
            while (numbers >= 10000000000L) {
                numbers /= 10L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        StringBuilder buffer = new StringBuilder(13);
        buffer.append('(');
        buffer.append(StringHelper.padZero((int)(numbers / 10000000L), 3));
        buffer.append(')');
        buffer.append(StringHelper.padZero((int)((numbers %= 10000000L) / 10000L), 3));
        buffer.append('-');
        buffer.append(StringHelper.padZero((int)(numbers %= 10000L), 4));
        return buffer.toString();
    }

    public static String format(String phoneNumber, String formatPattern) {
        String numbersOnly;
        String formatted = "";
        if (StringHelper.isNonEmpty(phoneNumber) && StringHelper.isNonEmpty(formatPattern) && StringHelper.isNonEmpty(numbersOnly = StringHelper.stripNonNumeric(phoneNumber))) {
            numbersOnly = StringHelper.padArbitraryRight('0', numbersOnly, 10);
            int index = 0;
            StringBuilder toReturn = new StringBuilder(formatPattern.length());
            char[] cArray = formatPattern.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char ch = cArray[n2];
                if (ch == 'X' && index < numbersOnly.length()) {
                    toReturn.append(numbersOnly.charAt(index++));
                } else {
                    toReturn.append(ch);
                }
                ++n2;
            }
            formatted = toReturn.toString();
        }
        return formatted;
    }

    public static boolean isValidUS(String number) {
        String validLeftSeparator = " (-.";
        String validRightSeparator = " )-.";
        String validSeparator = " -.";
        if (number != null && number.trim().length() >= 10) {
            int index;
            String trimmed = number.trim();
            if (!NumberHelper.isNumber(trimmed.substring(index = 0, index + 1))) {
                if (validLeftSeparator.indexOf(trimmed.substring(index, index + 1)) < 0) {
                    return false;
                }
                ++index;
            } else if (trimmed.substring(index, index + 1).equals("1")) {
                if (validLeftSeparator.indexOf(trimmed.substring(++index, index + 1)) < 0) {
                    return false;
                }
                ++index;
            }
            int i = index;
            while (i < index + 3) {
                if (!NumberHelper.isNumber(trimmed.substring(i, i + 1))) {
                    return false;
                }
                if (i == index && trimmed.substring(i, i + 1).equals("1")) {
                    return false;
                }
                ++i;
            }
            if (validRightSeparator.indexOf(trimmed.substring(index += 3, index + 1)) < 0) {
                return false;
            }
            if (!trimmed.substring(++index, index + 1).equals(" ")) {
                if (!NumberHelper.isNumber(trimmed.substring(index, index + 1))) {
                    return false;
                }
            } else {
                ++index;
            }
            int j = index;
            while (j < index + 3) {
                if (!NumberHelper.isNumber(trimmed.substring(j, j + 1))) {
                    return false;
                }
                ++j;
            }
            if (validSeparator.indexOf(trimmed.substring(index += 3, index + 1)) < 0) {
                return false;
            }
            int k = ++index;
            while (k < index + 4) {
                if (!NumberHelper.isNumber(trimmed.substring(k, k + 1))) {
                    return false;
                }
                ++k;
            }
            return true;
        }
        return false;
    }

    private PhoneHelper() {
    }
}

