/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.StringHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class ReflectionHelper {
    public static final Object[] NO_VALUES = new Object[0];
    public static final Class<?>[] NO_PARAMETERS = new Class[0];

    public static Object[] copy(Object[] source, String getMethodName) {
        Object[] result = new Object[source.length];
        Class<?> previousClass = null;
        Method method = null;
        int i = 0;
        while (i < source.length) {
            block9: {
                Object sourceObject = source[i];
                if (sourceObject != null) {
                    Class<?> objClass = sourceObject.getClass();
                    if (objClass != previousClass) {
                        previousClass = objClass;
                        method = ReflectionHelper.findMethod(objClass, getMethodName);
                        if (method == null) {
                            return new Object[0];
                        }
                    }
                    try {
                        if (method != null) {
                            result[i] = method.invoke(sourceObject, null);
                            break block9;
                        }
                        return new Object[0];
                    }
                    catch (IllegalAccessException iaexc) {
                        return new Object[0];
                    }
                    catch (IllegalArgumentException iaexc) {
                        return new Object[0];
                    }
                    catch (InvocationTargetException iaexc) {
                        return new Object[0];
                    }
                }
            }
            ++i;
        }
        return result;
    }

    public static Collection<? extends Object> copy(Collection<? extends Object> source, String getMethodName) {
        ArrayList<Object> result = new ArrayList<Object>(source.size());
        Class<?> previousClass = null;
        Method method = null;
        for (Object object : source) {
            Class<?> objClass = object.getClass();
            if (objClass != previousClass) {
                previousClass = objClass;
                method = ReflectionHelper.findMethod(objClass, getMethodName);
                if (method == null) {
                    return new ArrayList(0);
                }
            }
            try {
                if (method != null) {
                    result.add(method.invoke(object, null));
                    continue;
                }
                return new ArrayList(0);
            }
            catch (IllegalAccessException iaexc) {
                return new ArrayList(0);
            }
            catch (IllegalArgumentException iaexc) {
                return new ArrayList(0);
            }
            catch (InvocationTargetException itexc) {
                return new ArrayList(0);
            }
        }
        return result;
    }

    public static <V> Map<Object, V> mappify(Collection<V> source, String keyMethodName) {
        HashMap result = new HashMap(source.size());
        ReflectionHelper.mappify(source, result, keyMethodName);
        return result;
    }

    public static <V> void mappify(Collection<V> source, Map<Object, V> destination, String keyMethodName) {
        Class<?> previousClass = null;
        Method method = null;
        for (V sourceObject : source) {
            Class<?> objClass = sourceObject.getClass();
            if (objClass == previousClass) continue;
            previousClass = objClass;
            method = ReflectionHelper.findMethod(objClass, keyMethodName);
            if (method == null) continue;
            try {
                destination.put(method.invoke(sourceObject, null), sourceObject);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static Method findMethod(Class<? extends Object> objClass, String methodName) {
        return ReflectionHelper.findMethod(objClass, methodName, new Class[0]);
    }

    public static Method findMethod(Class<? extends Object> objClass, String methodName, Class<? extends Object>[] parameterTypes) {
        if (StringHelper.isEmptyTrimmed(methodName)) {
            return null;
        }
        String name = methodName.trim();
        Method method = null;
        Class<? extends Object> localClass = objClass;
        while (method == null && localClass != null) {
            try {
                method = localClass.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            localClass = localClass.getSuperclass();
        }
        return method;
    }

    public static Collection<Method> findMethodsByName(Class<? extends Object> objClass, String methodName, boolean ignoreCase) {
        if (StringHelper.isEmptyTrimmed(methodName)) {
            return new ArrayList<Method>(0);
        }
        ArrayList<Method> result = new ArrayList<Method>();
        Class<? extends Object> work = objClass;
        while (work != null) {
            Method[] methods = work.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getName().equals(methodName) || ignoreCase && methods[i].getName().equalsIgnoreCase(methodName)) {
                    result.add(methods[i]);
                }
                ++i;
            }
            work = work.getSuperclass();
        }
        return result;
    }

    public static Method findMethod(Object obj, String methodName) {
        return ReflectionHelper.findMethod(obj.getClass(), methodName);
    }

    public static Method findMethod(Object obj, String methodName, Class<? extends Object>[] parameterTypes) {
        return ReflectionHelper.findMethod(obj.getClass(), methodName, parameterTypes);
    }

    public static Object invokeIgnoringErrors(Object obj, String methodName) {
        return ReflectionHelper.invokeIgnoringErrors(obj, methodName, new Object[0]);
    }

    public static Object invokeIgnoringErrors(Object obj, String methodName, Object[] parameters) {
        try {
            return ReflectionHelper.invoke(obj, methodName, parameters);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Object invoke(Object obj, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return ReflectionHelper.invoke(obj, methodName, new Object[0]);
    }

    public static Object invoke(Object obj, String methodName, Object[] parameters) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class[] parameterTypes = (Class[])ReflectionHelper.copy(parameters, "getClass");
        Method method = ReflectionHelper.findMethod(obj, methodName, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException("No method named '" + methodName + "' with parameter types '" + StringHelper.join(", ", parameterTypes) + "' could be found in class '" + obj.getClass() + "'");
        }
        return method.invoke(obj, parameters);
    }

    private ReflectionHelper() {
    }
}

