/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import com.techempower.helper.CollectionHelper;
import com.techempower.util.UtilityConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;

public final class StringHelper {
    private static final String[] NEWLINE_FINDS = new String[]{"\n", "\r"};
    private static final String[] NEWLINE_REPLACES = new String[]{"", ""};
    private static final String SPACES = "                                                                    ";
    private static final String[] SINGLE_QUOTE_ESCAPE_FINDS = new String[]{"'"};
    private static final String[] SINGLE_QUOTE_ESCAPE_REPLACES = new String[]{"''"};
    private static final Random RANDOM = new Random();
    private static final char[] RANDOM_PATTERN_a = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] RANDOM_PATTERN_A = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] RANDOM_PATTERN_U = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] RANDOM_PATTERN_n = "abcdefghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final char[] RANDOM_PATTERN_N = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final char[] RANDOM_PATTERN_d = "0123456789".toCharArray();
    private static final char[] RANDOM_PATTERN_x = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final char[] RANDOM_PATTERN_s = "-=/\\[]()!@#$&".toCharArray();
    private static final char[] RANDOM_PATTERN_p = "ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz23456789".toCharArray();

    public static String pluralize(int value) {
        if (value != 1) {
            return "s";
        }
        return "";
    }

    public static String pluralize(int value, String singularSuffix, String pluralSuffix) {
        if (value != 1) {
            return pluralSuffix;
        }
        return singularSuffix;
    }

    public static String padZero(int number, int digits) {
        return StringHelper.padArbitrary('0', Integer.toString(number), digits);
    }

    public static String padZero(long number, int digits) {
        return StringHelper.padArbitrary('0', Long.toString(number), digits);
    }

    public static String padZero(String string, int digits) {
        return StringHelper.padArbitrary('0', string, digits);
    }

    public static String padSpace(int number, int digits) {
        return StringHelper.padArbitrary(' ', Integer.toString(number), digits);
    }

    public static String padSpace(long number, int digits) {
        return StringHelper.padArbitrary(' ', Long.toString(number), digits);
    }

    public static String padSpace(String string, int digits) {
        return StringHelper.padArbitrary(' ', string, digits);
    }

    public static String padArbitrary(char pad, String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        char[] buffer = new char[length];
        int padding = length - string.length();
        int position = 0;
        while (position < padding) {
            buffer[position] = pad;
            ++position;
        }
        System.arraycopy(string.toCharArray(), 0, buffer, position, string.length());
        return new String(buffer);
    }

    public static String padArbitraryRight(char pad, String string, int length) {
        if (string.length() >= length) {
            return string;
        }
        char[] buffer = new char[length];
        int position = string.length();
        while (position < length) {
            buffer[position] = pad;
            ++position;
        }
        System.arraycopy(string.toCharArray(), 0, buffer, 0, string.length());
        return new String(buffer);
    }

    public static String intern(String str) {
        if (str != null) {
            return str.intern();
        }
        return null;
    }

    public static boolean isNonEmpty(String inputString) {
        return inputString != null && inputString.length() > 0;
    }

    public static boolean isNonEmpty(String ... inputString) {
        if (inputString == null || inputString.length == 0) {
            return false;
        }
        String[] stringArray = inputString;
        int n = inputString.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (StringHelper.isEmpty(string)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEmpty(String inputString) {
        return inputString == null || inputString.length() < 1;
    }

    public static boolean isEmpty(String ... inputString) {
        if (inputString == null || inputString.length == 0) {
            return true;
        }
        String[] stringArray = inputString;
        int n = inputString.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null && string.length() > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isEmptyTrimmed(String inputString) {
        return inputString == null || StringHelper.trim(inputString).length() == 0;
    }

    public static boolean isEmptyTrimmed(String ... inputStrings) {
        if (inputStrings == null || inputStrings.length == 0) {
            return true;
        }
        String[] stringArray = inputStrings;
        int n = inputStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String inputString = stringArray[n2];
            if (StringHelper.isNonEmptyTrimmed(inputString)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isNonEmptyTrimmed(String inputString) {
        return inputString != null && StringHelper.trim(inputString).length() > 0;
    }

    public static boolean isNonEmptyTrimmed(String ... inputStrings) {
        if (inputStrings == null || inputStrings.length == 0) {
            return false;
        }
        String[] stringArray = inputStrings;
        int n = inputStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String inputString = stringArray[n2];
            if (StringHelper.isEmptyTrimmed(inputString)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static String emptyDefault(String stringToTest, String defaultValue) {
        if (StringHelper.isEmpty(stringToTest)) {
            return defaultValue;
        }
        return stringToTest;
    }

    public static boolean equalsIgnoreCaseTrim(String s1, String[] s2) {
        return StringHelper.equalsIgnoreCaseTrim(s1, CollectionHelper.toList(s2));
    }

    public static boolean equalsIgnoreCaseTrim(String s1, Collection<String> s2) {
        if (s1 != null && CollectionHelper.isNonEmpty(s2)) {
            Iterator<String> itr = s2.iterator();
            while (itr.hasNext()) {
                if (!StringHelper.equalsIgnoreCaseTrim(s1, itr.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreCaseTrim(String s1, String s2) {
        return StringHelper.equalsIgnoreCase(StringHelper.trim(s1), StringHelper.trim(s2));
    }

    public static boolean equalsIgnoreCase(String s1, String[] s2) {
        return StringHelper.equalsIgnoreCase(s1, CollectionHelper.toList(s2));
    }

    public static boolean equalsIgnoreCase(String s1, Collection<String> s2) {
        if (s1 != null && CollectionHelper.isNonEmpty(s2)) {
            Iterator<String> itr = s2.iterator();
            while (itr.hasNext()) {
                if (!StringHelper.equalsIgnoreCase(s1, itr.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equalsIgnoreCase(s2);
        }
        return false;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return false;
    }

    public static boolean containsWord(String sentence, String word) {
        return sentence != null && word != null && sentence.matches("(.*)(\\s|^)" + Pattern.quote(word) + "(\\s|$)(.*)");
    }

    public static boolean containsIgnoreCase(String container, String searchingFor) {
        if (StringHelper.isNonEmpty(container) && StringHelper.isNonEmpty(searchingFor)) {
            return container.toLowerCase().indexOf(searchingFor.toLowerCase()) > -1;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String s1, String[] s2) {
        return StringHelper.containsIgnoreCaseTrim(s1, CollectionHelper.toList(s2));
    }

    public static boolean containsIgnoreCase(String s1, Collection<String> s2) {
        return StringHelper.containsIgnoreCaseTrim(s1, s2);
    }

    public static boolean containsIgnoreCaseTrim(String s1, Collection<String> s2) {
        if (s1 != null && CollectionHelper.isNonEmpty(s2)) {
            Iterator<String> itr = s2.iterator();
            while (itr.hasNext()) {
                if (!StringHelper.containsIgnoreCaseTrim(s1, itr.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsIgnoreCaseTrim(String s1, String s2) {
        return StringHelper.containsIgnoreCase(StringHelper.trim(s1), StringHelper.trim(s2));
    }

    public static boolean containsAt(String reference, String toFind, int location) {
        if (reference == null || toFind == null) {
            return false;
        }
        if (reference.length() >= location + toFind.length()) {
            int i = 0;
            while (i < toFind.length()) {
                if (reference.charAt(location + i) != toFind.charAt(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean containsNullSafe(String toSearch, String searchTerm) {
        if (StringHelper.isEmpty(toSearch)) {
            return false;
        }
        if (StringHelper.isEmpty(searchTerm)) {
            return true;
        }
        return toSearch.indexOf(searchTerm) > -1;
    }

    public static boolean endsWithIgnoreCase(String s, String suffix) {
        return StringHelper.isNonEmpty(s) && StringHelper.isNonEmpty(suffix) && s.toLowerCase().endsWith(suffix.toLowerCase());
    }

    public static boolean endsWithIgnoreCase(String s, String[] suffix) {
        if (StringHelper.isNonEmpty(s) && CollectionHelper.isNonEmpty(suffix)) {
            int i = 0;
            while (i < suffix.length) {
                if (StringHelper.endsWithIgnoreCase(s, suffix[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(String s, String prefix) {
        return StringHelper.isNonEmpty(s) && StringHelper.isNonEmpty(prefix) && s.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static boolean startsWithIgnoreCase(String s, String[] prefix) {
        if (StringHelper.isNonEmpty(s) && CollectionHelper.isNonEmpty(prefix)) {
            int i = 0;
            while (i < prefix.length) {
                if (StringHelper.startsWithIgnoreCase(s, prefix[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String uppercaseFirstLetter(String input) {
        if (input == null) {
            return null;
        }
        char[] buffer = input.toCharArray();
        boolean uppercased = false;
        int i = 0;
        while (i < buffer.length) {
            if (!uppercased && buffer[i] >= 'a' && buffer[i] <= 'z') {
                buffer[i] = Character.toUpperCase(buffer[i]);
                break;
            }
            if (buffer[i] >= 'A' && buffer[i] <= 'Z') break;
            ++i;
        }
        return new String(buffer);
    }

    public static String uppercaseEachWord(String input) {
        if (input == null) {
            return null;
        }
        char[] buffer = input.toCharArray();
        boolean uppercased = false;
        int i = 0;
        while (i < buffer.length) {
            if (!uppercased && buffer[i] >= 'a' && buffer[i] <= 'z') {
                buffer[i] = Character.toUpperCase(buffer[i]);
                uppercased = true;
            } else if (buffer[i] >= 'A' && buffer[i] <= 'Z') {
                uppercased = true;
            } else if (buffer[i] < 'a' || buffer[i] > 'z') {
                uppercased = false;
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return "";
    }

    public static String[] trim(String[] s) {
        String[] toReturn = new String[]{};
        if (CollectionHelper.isNonEmpty(s)) {
            toReturn = new String[s.length];
            int i = 0;
            while (i < s.length) {
                toReturn[i] = StringHelper.trim(s[i]);
                ++i;
            }
        }
        return toReturn;
    }

    public static boolean isAllNumeric(String inputString) {
        if (inputString != null) {
            int i = 0;
            while (i < inputString.length()) {
                char currentChar = inputString.charAt(i);
                if (currentChar < '0' || currentChar > '9') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllAlpha(String inputString) {
        if (inputString != null) {
            int i = 0;
            while (i < inputString.length()) {
                char currentChar = inputString.charAt(i);
                if (!Character.isLetter(currentChar)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllAlphaNumeric(String inputString) {
        if (inputString != null) {
            int i = 0;
            while (i < inputString.length()) {
                char currentChar = inputString.charAt(i);
                if (!Character.isLetterOrDigit(currentChar)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllAlphaAndSpecialChars(String inputString, char[] characters) {
        return StringHelper.isAll(inputString, true, true, false, characters);
    }

    public static boolean isAllDigitsAndSpecialChars(String inputString, char[] characters) {
        return StringHelper.isAll(inputString, false, false, true, characters);
    }

    public static boolean isAllAlphaDigitsAndSpecialChars(String inputString, char[] characters) {
        return StringHelper.isAll(inputString, true, true, true, characters);
    }

    public static boolean isAll(String inputString, boolean bIncludeAlphaLowerCase, boolean bIncludeAlphaUpperCase, boolean bIncludeNumericDigits, char[] characters) {
        char[] acceptableCharacters = CollectionHelper.arrayMerge(true, (char[])(bIncludeAlphaLowerCase ? UtilityConstants.CHARACTERS_ALPHA_LOWERCASE : null), (char[])(bIncludeAlphaUpperCase ? UtilityConstants.CHARACTERS_ALPHA_UPPERCASE : null), (char[])(bIncludeNumericDigits ? UtilityConstants.CHARACTERS_NUMERIC : null), characters);
        return StringHelper.isAllArbitraryCharacters(inputString, acceptableCharacters);
    }

    public static boolean isAllArbitraryCharacters(String inputString, char[] acceptableCharacters) {
        if (inputString != null) {
            int i = 0;
            while (i < inputString.length()) {
                char currentChar = inputString.charAt(i);
                if (Arrays.binarySearch(acceptableCharacters, currentChar) < 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isAllArbitraryExcluding(String inputString, char[] unacceptableCharacters) {
        if (inputString != null) {
            int i = 0;
            while (i < inputString.length()) {
                char currentChar = inputString.charAt(i);
                if (Arrays.binarySearch(unacceptableCharacters, currentChar) >= 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String truncate(String input, int length) {
        if (input != null) {
            if (input.length() > length) {
                return input.substring(0, length);
            }
            return input;
        }
        return null;
    }

    public static String truncateAtEnd(String input, int length) {
        if (input != null) {
            if (input.length() > length) {
                return input.substring(input.length() - length, input.length());
            }
            return input;
        }
        return null;
    }

    public static String truncateEllipsis(String input, int length) {
        return StringHelper.truncateEllipsis(input, length, false);
    }

    public static String truncateEllipsis(String input, int length, boolean findWordBoundary) {
        return StringHelper.truncateEllipsis(input, length, findWordBoundary, "...");
    }

    public static String truncateEllipsis(String input, int length, boolean findWordBoundary, String ellipsis) {
        return StringHelper.truncateEllipsis(input, length, findWordBoundary, true, ellipsis);
    }

    public static String truncateEllipsis(String input, int targetLength, boolean findWordBoundary, boolean searchBackForWordBoundary, String ellipsis) {
        if (StringHelper.isEmpty(input)) {
            return "";
        }
        int length = targetLength;
        String suffix = ellipsis == null ? "" : ellipsis;
        if (length > suffix.length()) {
            length -= suffix.length();
        }
        if (input.length() > length) {
            if (findWordBoundary) {
                int space;
                int n = space = searchBackForWordBoundary ? input.lastIndexOf(32, length) : input.indexOf(32, length);
                if (space >= 1) {
                    length = space;
                }
            }
            return String.valueOf(input.substring(0, length)) + suffix;
        }
        return input;
    }

    public static String wordWrap(String input, int width, int indentFirstLine, int indentSubsequentLines) {
        return StringHelper.wordWrap(input, width, indentFirstLine, indentSubsequentLines, true);
    }

    public static String wordWrap(String input, int width, int indentFirstLine, int indentSubsequentLines, boolean insertFirstLineIndent) {
        if (input == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(input.length() * 2);
        String cleaned = StringHelper.replaceSubstrings(input, NEWLINE_FINDS, NEWLINE_REPLACES);
        int lineNumber = 0;
        int currentIndent = indentFirstLine;
        int currentPosition = 0;
        while (cleaned.length() > currentPosition + width - currentIndent) {
            int space = cleaned.lastIndexOf(32, currentPosition + width - currentIndent);
            int distance = space - currentPosition;
            if (space > currentPosition && distance < currentIndent + width) {
                if (lineNumber > 0 || insertFirstLineIndent) {
                    result.append(SPACES.substring(0, currentIndent));
                }
                result.append(cleaned.substring(currentPosition, currentPosition + distance));
                currentPosition = space + 1;
                while (cleaned.length() > currentPosition && cleaned.charAt(currentPosition) == ' ') {
                    ++currentPosition;
                }
                if (cleaned.length() > currentPosition) {
                    result.append("\r\n");
                    ++lineNumber;
                }
            } else {
                if (lineNumber > 0 || insertFirstLineIndent) {
                    result.append(SPACES.substring(0, currentIndent));
                }
                result.append(cleaned.substring(currentPosition, currentPosition + width - currentIndent));
                currentPosition = currentPosition + width - currentIndent;
                while (cleaned.length() > currentPosition && cleaned.charAt(currentPosition) == ' ') {
                    ++currentPosition;
                }
                if (cleaned.length() > currentPosition) {
                    result.append("\r\n");
                    ++lineNumber;
                }
            }
            if (lineNumber != 1) continue;
            currentIndent = indentSubsequentLines;
        }
        if (cleaned.length() > currentPosition) {
            if (lineNumber > 0 || insertFirstLineIndent) {
                result.append(SPACES.substring(0, currentIndent));
            }
            result.append(cleaned.substring(currentPosition));
        }
        return result.toString();
    }

    public static String[] splitAndTrim(String s, String regex) {
        String[] toReturn = new String[]{};
        if (StringHelper.isNonEmpty(s)) {
            toReturn = StringHelper.trim(s.split(regex));
        }
        return toReturn;
    }

    public static String[] splitTrimAndLower(String s, String regex) {
        String[] toReturn = new String[]{};
        if (StringHelper.isNonEmpty(s)) {
            toReturn = StringHelper.trim(s.toLowerCase().split(regex));
        }
        return toReturn;
    }

    public static String[] splitIntoLines(String s) {
        return StringHelper.splitAndTrim(s, "\r\n|\n");
    }

    public static String[] splitIntoWords(String s) {
        if (s == null) {
            return new String[0];
        }
        String work = s.trim();
        if (work.length() == 0) {
            return new String[0];
        }
        return work.split("\\s+");
    }

    public static String[] trimExcessBlankLines(String[] lines) {
        if (lines == null) {
            return null;
        }
        boolean prevBlank = false;
        ArrayList<String> work = new ArrayList<String>();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].length() == 0) {
                if (!prevBlank) {
                    work.add(lines[i]);
                    prevBlank = true;
                }
            } else {
                work.add(lines[i]);
                prevBlank = false;
            }
            ++i;
        }
        String[] toReturn = new String[work.size()];
        return work.toArray(toReturn);
    }

    public static boolean parseBoolean(String boolStr) {
        block26: {
            if (boolStr == null) break block26;
            switch (boolStr.trim().toLowerCase()) {
                case "1": 
                case "y": 
                case "on": 
                case "yes": 
                case "true": {
                    return true;
                }
                case "0": 
                case "n": 
                case "no": 
                case "off": 
                case "false": {
                    return false;
                }
            }
        }
        throw new NumberFormatException("'" + boolStr + "' is not a valid boolean value.");
    }

    public static boolean parseBoolean(String boolStr, boolean defaultValue) {
        try {
            return StringHelper.parseBoolean(boolStr);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static String stripISOControlCharacters(String inputString, String replaceWith) {
        if (StringHelper.isNonEmpty(inputString)) {
            StringBuilder result = new StringBuilder(inputString.length());
            int i = 0;
            while (i < inputString.length()) {
                char aChar = inputString.charAt(i);
                if (Character.isISOControl(aChar)) {
                    if (StringHelper.isNonEmpty(replaceWith)) {
                        result.append(replaceWith);
                    }
                } else {
                    result.append(aChar);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripNonAlphanumeric(String inputString) {
        if (StringHelper.isNonEmpty(inputString)) {
            StringBuilder result = new StringBuilder(inputString.length());
            int i = 0;
            while (i < inputString.length()) {
                char aChar = inputString.charAt(i);
                if (aChar >= 'a' && aChar <= 'z' || aChar >= 'A' && aChar <= 'Z' || aChar >= '0' && aChar <= '9') {
                    result.append(aChar);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripNonNumeric(String inputString) {
        if (StringHelper.isNonEmpty(inputString)) {
            StringBuilder result = new StringBuilder(inputString.length());
            int i = 0;
            while (i < inputString.length()) {
                char aChar = inputString.charAt(i);
                if (aChar >= '0' && aChar <= '9') {
                    result.append(aChar);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripArbitraryCharacters(String inputString, char[] acceptableCharacters) {
        if (inputString != null) {
            StringBuilder result = new StringBuilder(inputString.length());
            int i = 0;
            while (i < inputString.length()) {
                char aChar = inputString.charAt(i);
                if (Arrays.binarySearch(acceptableCharacters, aChar) >= 0) {
                    result.append(aChar);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripUnacceptableCharacters(String inputString, char[] unacceptableCharacters) {
        if (inputString != null) {
            StringBuilder result = new StringBuilder(inputString.length());
            int i = 0;
            while (i < inputString.length()) {
                char aChar = inputString.charAt(i);
                if (Arrays.binarySearch(unacceptableCharacters, aChar) < 0) {
                    result.append(aChar);
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripExtraSpaces(String inputString) {
        if (inputString != null) {
            String trimmed = inputString.trim();
            StringBuilder result = new StringBuilder(trimmed.length());
            int i = 0;
            while (i < trimmed.length()) {
                char aChar = trimmed.charAt(i);
                if (aChar != ' ') {
                    result.append(aChar);
                } else if (result.length() > 0 && result.charAt(result.length() - 1) != ' ') {
                    result.append(' ');
                }
                ++i;
            }
            return result.toString();
        }
        return null;
    }

    public static String stripDoubleDoubleQuotes(String source) {
        return StringHelper.replaceSubstrings(source, "\"\"", "\"");
    }

    public static String macroExpand(Map<String, ? extends Object> macros, String text) {
        if (macros == null) {
            return text;
        }
        String[] find = new String[macros.size()];
        String[] replace = new String[macros.size()];
        int position = 0;
        Iterator<String> iterator = macros.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            find[position] = key = iterator.next();
            Object value = macros.get(key);
            String string = replace[position++] = value != null ? value.toString() : "";
        }
        return StringHelper.replaceSubstrings(text, text, find, replace);
    }

    public static String escapeSingleQuotes(String inputString) {
        return StringHelper.replaceSubstrings(inputString, SINGLE_QUOTE_ESCAPE_FINDS, SINGLE_QUOTE_ESCAPE_REPLACES);
    }

    public static String escapeDoubleQuotes(String inputString) {
        if (inputString != null) {
            StringBuilder newString = new StringBuilder(inputString.length());
            int start = 0;
            int quoteLocation = inputString.indexOf(34, start);
            while (quoteLocation > -1) {
                newString.append(inputString.substring(start, quoteLocation));
                newString.append("\"\"");
                start = quoteLocation + 1;
                quoteLocation = inputString.indexOf(34, start);
            }
            newString.append(inputString.substring(start));
            return newString.toString();
        }
        return "";
    }

    public static String replaceSubstrings(String source, String search, String replacement) {
        return StringHelper.replaceSubstrings(source, search, replacement, true);
    }

    public static String replaceSubstrings(String source, String search, String replacement, boolean ignoreCase) {
        if (ignoreCase) {
            return StringHelper.replaceSubstringsIgnoreCase(source, new String[]{search}, new String[]{replacement});
        }
        return StringHelper.replaceSubstrings(source, new String[]{search}, new String[]{replacement});
    }

    public static String replaceSubstrings(String source, String[] find, String[] replace) {
        return StringHelper.replaceSubstrings(source, source, find, replace);
    }

    public static String replaceSubstringsIgnoreCase(String source, String[] find, String[] replace) {
        if (source == null) {
            return "";
        }
        String uppercaseSearch = source.toUpperCase();
        String[] upperFind = new String[find.length];
        int i = 0;
        while (i < find.length) {
            upperFind[i] = find[i].toUpperCase();
            ++i;
        }
        return StringHelper.replaceSubstrings(source, uppercaseSearch, upperFind, replace);
    }

    public static String replaceSubstrings(String source, String search, String[] find, String[] replace) {
        if (source == null) {
            return "";
        }
        if (search == null || find == null || replace == null) {
            return source;
        }
        StringBuilder buffer = new StringBuilder(source.length());
        int position = 0;
        while (position < source.length()) {
            int selection = -1;
            int foundAtPosition = -1;
            int findIndex = 0;
            while (findIndex < find.length && findIndex < replace.length) {
                int currentFound = search.indexOf(find[findIndex], position);
                if (currentFound >= 0 && (currentFound < foundAtPosition || foundAtPosition == -1)) {
                    foundAtPosition = currentFound;
                    selection = findIndex;
                }
                ++findIndex;
            }
            if (selection >= 0) {
                buffer.append(source.substring(position, foundAtPosition));
                buffer.append(replace[selection]);
                position = foundAtPosition + find[selection].length();
                continue;
            }
            buffer.append(source.substring(position));
            position = source.length();
        }
        return buffer.toString();
    }

    public static String replaceCharacters(String inputString, char[] finds, char[] replacements) {
        char[] buffer = inputString.toCharArray();
        int i = 0;
        while (i < buffer.length) {
            int f = 0;
            while (f < finds.length) {
                if (buffer[i] == finds[f]) {
                    buffer[i] = replacements[f];
                    break;
                }
                ++f;
            }
            ++i;
        }
        return new String(buffer);
    }

    public static String getRandom(char[] chars, int length) {
        char[] buffer = new char[length];
        int i = 0;
        while (i < length) {
            buffer[i] = chars[RANDOM.nextInt(chars.length)];
            ++i;
        }
        return new String(buffer);
    }

    public static String getRandom(String chars, int length) {
        return StringHelper.getRandom(chars.toCharArray(), length);
    }

    public static String getRandomAlphaNumeric(int length) {
        return StringHelper.getRandom("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", length);
    }

    @Deprecated
    public static String getRandomAlphanumeric(int length) {
        return StringHelper.getRandomAlphaNumeric(length);
    }

    public static String getRandomNumeric(int length) {
        return StringHelper.getRandom("0123456789", length);
    }

    public static String getRandomUppercase(int length) {
        return StringHelper.getRandom("ABCDEFGHIJKLMNOPQRSTUVWXYZ", length);
    }

    public static String getRandomLowercase(int length) {
        return StringHelper.getRandom("abcdefghijklmnopqrstuvwxyz", length);
    }

    public static String getRandomPassword(int length) {
        return StringHelper.getRandom(RANDOM_PATTERN_p, length);
    }

    public static String getRandomStandardSymbol(int length) {
        return StringHelper.getRandom("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~", length);
    }

    public static String getRandomFromPattern(String pattern) {
        char[] buffer = new char[pattern.length()];
        int i = 0;
        while (i < pattern.length()) {
            switch (pattern.charAt(i)) {
                case 'a': {
                    buffer[i] = RANDOM_PATTERN_a[RANDOM.nextInt(RANDOM_PATTERN_a.length)];
                    break;
                }
                case 'A': {
                    buffer[i] = RANDOM_PATTERN_A[RANDOM.nextInt(RANDOM_PATTERN_A.length)];
                    break;
                }
                case 'U': {
                    buffer[i] = RANDOM_PATTERN_U[RANDOM.nextInt(RANDOM_PATTERN_U.length)];
                    break;
                }
                case 'n': {
                    buffer[i] = RANDOM_PATTERN_n[RANDOM.nextInt(RANDOM_PATTERN_n.length)];
                    break;
                }
                case 'N': {
                    buffer[i] = RANDOM_PATTERN_N[RANDOM.nextInt(RANDOM_PATTERN_N.length)];
                    break;
                }
                case 'd': {
                    buffer[i] = RANDOM_PATTERN_d[RANDOM.nextInt(RANDOM_PATTERN_d.length)];
                    break;
                }
                case 's': {
                    buffer[i] = RANDOM_PATTERN_s[RANDOM.nextInt(RANDOM_PATTERN_s.length)];
                    break;
                }
                case 'p': {
                    buffer[i] = RANDOM_PATTERN_p[RANDOM.nextInt(RANDOM_PATTERN_p.length)];
                    break;
                }
                default: {
                    buffer[i] = RANDOM_PATTERN_x[RANDOM.nextInt(RANDOM_PATTERN_x.length)];
                }
            }
            ++i;
        }
        return new String(buffer);
    }

    public static int compareToIgnoreCase(String a, String b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareToIgnoreCase(b));
    }

    public static int compareToNullSafe(String a, String b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : a.compareTo(b));
    }

    public static String join(String separator, Iterable<?> values) {
        if (values == null) {
            return "";
        }
        Iterator<?> iter = values.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(iter.next());
        while (iter.hasNext()) {
            sb.append(separator).append(iter.next());
        }
        return sb.toString();
    }

    @SafeVarargs
    public static final <E> String join(String separator, E ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, String ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, char ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, byte ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, short ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, int ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, long ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, float ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, double ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String join(String separator, boolean ... values) {
        if (values == null || values.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder().append(values[0]);
        int i = 1;
        while (i < values.length) {
            sb.append(separator).append(values[i]);
            ++i;
        }
        return sb.toString();
    }

    private StringHelper() {
    }
}

