/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.helper;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ThreadHelper {
    private static final Comparator<Thread> THREAD_NAME_COMPARATOR = new Comparator<Thread>(){

        @Override
        public int compare(Thread t1, Thread t2) {
            return t1.getName().compareToIgnoreCase(t2.getName());
        }
    };
    private static final ThreadGroup ROOT_THREAD_GROUP;
    private static final ExecutorService JOB_EXECUTOR;
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR;
    private static final int ACTIVE_THREAD_OVERBUFFER = 10;

    static {
        JOB_EXECUTOR = Executors.newCachedThreadPool();
        SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2);
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        ROOT_THREAD_GROUP = group;
    }

    public static Future<?> submit(Callable<?> callable) {
        return JOB_EXECUTOR.submit(callable);
    }

    public static void submit(Runnable runnable) {
        JOB_EXECUTOR.execute(runnable);
    }

    public static Future<?> schedule(Callable<?> callable, long delay, TimeUnit unit) {
        return SCHEDULED_EXECUTOR.schedule(callable, delay, unit);
    }

    public static void schedule(Runnable runnable, long delay, TimeUnit unit) {
        SCHEDULED_EXECUTOR.schedule(runnable, delay, unit);
    }

    public static void scheduleWithFixedDelay(Runnable callable, long initialDelay, long delay, TimeUnit unit) {
        SCHEDULED_EXECUTOR.scheduleWithFixedDelay(callable, initialDelay, delay, unit);
    }

    public static void scheduleAtFixedRate(Runnable callable, long initialDelay, long period, TimeUnit unit) {
        SCHEDULED_EXECUTOR.scheduleAtFixedRate(callable, initialDelay, period, unit);
    }

    public static ThreadGroup getRootThreadGroup() {
        return ROOT_THREAD_GROUP;
    }

    public static Thread[] getActiveThreads(boolean sorted) {
        ThreadGroup group = ThreadHelper.getRootThreadGroup();
        int activeThreads = group.activeCount();
        Thread[] temporaryThreads = new Thread[activeThreads + 10];
        int returned = group.enumerate(temporaryThreads);
        Thread[] threads = new Thread[returned];
        System.arraycopy(temporaryThreads, 0, threads, 0, returned);
        if (sorted) {
            Arrays.sort(threads, THREAD_NAME_COMPARATOR);
        }
        return threads;
    }

    public static Thread getThread(long id) {
        Thread[] threads = ThreadHelper.getActiveThreads(false);
        int i = 0;
        while (i < threads.length) {
            if (threads[i].getId() == id) {
                return threads[i];
            }
            ++i;
        }
        return null;
    }

    private ThreadHelper() {
    }
}

