/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.io.csv;

import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;

public class CsvReader
implements AutoCloseable {
    private String filename;
    private String currentLine;
    private Reader reader;
    private LineNumberReader lnr;
    private String[] columns;
    private String[] current;
    private boolean initialized = false;

    public CsvReader(String filename) {
        this.filename = filename;
    }

    public CsvReader(Reader openReader) {
        this.reader = openReader;
    }

    public String[] getColumns() {
        this.initialize();
        return this.columns;
    }

    public String[] getValues() {
        this.initialize();
        return this.current;
    }

    public String getString(String fieldName) {
        this.initialize();
        int i = 0;
        while (i < this.columns.length) {
            if (fieldName.equalsIgnoreCase(this.columns[i])) {
                return this.current[i];
            }
            ++i;
        }
        return null;
    }

    public int getInt(String fieldName, int defaultValue) {
        return NumberHelper.parseInt(this.getString(fieldName), defaultValue);
    }

    public boolean getBoolean(String fieldName, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getString(fieldName));
        }
        catch (IllegalArgumentException iaexc) {
            return defaultValue;
        }
    }

    public String getCurrentLine() {
        this.initialize();
        return this.currentLine;
    }

    public boolean next() {
        this.initialize();
        try {
            this.currentLine = this.lnr.readLine();
            if (this.currentLine != null) {
                this.current = new String[this.columns.length];
                this.parseLine(this.currentLine, this.current);
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.lnr != null) {
            try {
                this.lnr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lnr = null;
        }
    }

    protected String emptyIfNull(String input) {
        if (input == null) {
            return "";
        }
        return input;
    }

    protected void parseLine(String input, String[] output) {
        char[] line = new char[input.length()];
        input.getChars(0, input.length(), line, 0);
        int i = 0;
        while (i < output.length) {
            output[i] = "";
            ++i;
        }
        int startingPos = 0;
        int currentPos = 0;
        int currentIndex = 0;
        boolean quoted = false;
        boolean escapedDoubleQuote = false;
        while (currentPos < line.length) {
            if (startingPos == currentPos) {
                quoted = line[currentPos] == '\"';
                escapedDoubleQuote = false;
            }
            if (currentIndex < output.length) {
                if (!quoted && line[currentPos] == ',') {
                    output[currentIndex] = this.emptyIfNull(input.substring(startingPos, currentPos));
                    ++currentIndex;
                    startingPos = currentPos + 1;
                } else if (!quoted && currentPos == line.length - 1) {
                    output[currentIndex] = this.emptyIfNull(input.substring(startingPos, currentPos + 1));
                    ++currentIndex;
                    startingPos = currentPos + 1;
                } else if (quoted && line[currentPos] == '\"' && currentPos != startingPos) {
                    if (currentPos < line.length - 1 && line[currentPos + 1] == '\"') {
                        escapedDoubleQuote = true;
                        ++currentPos;
                    } else {
                        output[currentIndex] = escapedDoubleQuote ? StringHelper.stripDoubleDoubleQuotes(this.emptyIfNull(input.substring(startingPos + 1, currentPos))) : this.emptyIfNull(input.substring(startingPos + 1, currentPos));
                        ++currentIndex;
                        startingPos = currentPos + 2;
                    }
                }
            }
            ++currentPos;
        }
    }

    protected void parseLine(String input, Collection<String> output) {
        char[] line = new char[input.length()];
        input.getChars(0, input.length(), line, 0);
        int startingPos = 0;
        int currentPos = 0;
        boolean quoted = false;
        boolean escapedDoubleQuote = false;
        while (currentPos < line.length) {
            if (startingPos == currentPos) {
                quoted = line[currentPos] == '\"';
                escapedDoubleQuote = false;
                if (currentPos == line.length - 1) {
                    output.add(this.emptyIfNull(input.substring(startingPos, currentPos + 1)));
                    startingPos = currentPos + 1;
                }
                if (line[currentPos] == ',') {
                    output.add("");
                    startingPos = currentPos + 1;
                }
            } else if (!quoted && line[currentPos] == ',') {
                output.add(this.emptyIfNull(input.substring(startingPos, currentPos)));
                startingPos = currentPos + 1;
            } else if (!quoted && currentPos == line.length - 1) {
                output.add(this.emptyIfNull(input.substring(startingPos, currentPos + 1)));
                startingPos = currentPos + 1;
            } else if (quoted && line[currentPos] == '\"') {
                if (currentPos < line.length - 1 && line[currentPos + 1] == '\"') {
                    escapedDoubleQuote = true;
                    ++currentPos;
                } else {
                    if (escapedDoubleQuote) {
                        output.add(StringHelper.stripDoubleDoubleQuotes(this.emptyIfNull(input.substring(startingPos + 1, currentPos))));
                    } else {
                        output.add(this.emptyIfNull(input.substring(startingPos + 1, currentPos)));
                    }
                    startingPos = currentPos + 2;
                }
            }
            ++currentPos;
        }
    }

    protected void initialize() {
        if (!this.initialized) {
            try {
                try {
                    if (this.reader == null) {
                        this.reader = new FileReader(this.filename);
                    }
                    this.lnr = new LineNumberReader(this.reader);
                    String columnLine = this.lnr.readLine();
                    if (columnLine != null) {
                        ArrayList<String> columnsCollection = new ArrayList<String>();
                        this.parseLine(columnLine, columnsCollection);
                        this.columns = new String[columnsCollection.size()];
                        int i = 0;
                        while (i < columnsCollection.size()) {
                            this.columns[i] = columnsCollection.get(i);
                            ++i;
                        }
                        this.initialized = true;
                    }
                }
                catch (IOException iOException) {
                    if (!this.initialized) {
                        this.close();
                    }
                }
            }
            finally {
                if (!this.initialized) {
                    this.close();
                }
            }
        }
    }

    public static void main(String[] args) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CsvReader r = new CsvReader("C:\\temp\\test.csv");){
            while (r.next()) {
                r.displayValues();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void displayValues() {
        int i = 0;
        while (i < this.columns.length) {
            System.out.print(String.valueOf(i) + ": " + this.columns[i]);
            if (this.current != null) {
                System.out.print(" (" + this.current[i] + ")");
            }
            System.out.println("");
            ++i;
        }
    }
}

