/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.io.csv;

import com.techempower.helper.StringHelper;
import com.techempower.util.StringList;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class CsvWriter
implements AutoCloseable {
    private String[] columns;
    private Collection<String> columnsCollection;
    private Writer writer;
    private boolean initialized = false;

    public CsvWriter(String filename, Collection<String> columns) throws IOException {
        this.writer = new FileWriter(filename);
        this.columnsCollection = columns;
    }

    public CsvWriter(String filename, String[] columns) throws IOException {
        this.writer = new FileWriter(filename);
        this.columns = new String[columns.length];
        System.arraycopy(columns, 0, this.columns, 0, columns.length);
    }

    public CsvWriter(Writer writer, Collection<String> columns) {
        this.writer = writer;
        this.columnsCollection = columns;
    }

    public CsvWriter(Writer writer, String[] columns) {
        this.writer = writer;
        this.columns = columns;
    }

    public void writeLine(Map<String, String> lineValues) throws IOException {
        this.initialize();
        StringList line = new StringList(",");
        int i = 0;
        while (i < this.columns.length) {
            String value = lineValues.get(this.columns[i]);
            if (value != null) {
                if (value.indexOf(34) >= 0) {
                    value = StringHelper.replaceSubstrings(value, "\"", "\"\"");
                }
                if (value.indexOf(44) >= 0 || value.indexOf(34) >= 0) {
                    line.add("\"" + value + "\"");
                } else {
                    line.add(value);
                }
            } else {
                line.add("");
            }
            ++i;
        }
        this.writer.write(line + "\r\n");
    }

    public void writeLine(String[] values) throws IOException {
        this.initialize();
        this.writer.write(String.valueOf(this.prepareLine(values)) + "\r\n");
    }

    public String prepareLine(String[] values) {
        StringList line = new StringList(",");
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                String value = values[i];
                if (value.indexOf(34) >= 0) {
                    value = StringHelper.replaceSubstrings(value, "\"", "\"\"");
                }
                if (value.indexOf(44) >= 0 || value.indexOf(34) >= 0) {
                    line.add("\"" + value + "\"");
                } else {
                    line.add(value);
                }
            } else {
                line.add("");
            }
            ++i;
        }
        return line.toString();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    protected void initialize() throws IOException {
        if (!this.initialized) {
            if (this.columns == null) {
                this.columns = new String[this.columnsCollection.size()];
                Iterator<String> iter = this.columnsCollection.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.columns[i++] = iter.next();
                }
            }
            this.writer.write(String.valueOf(this.prepareLine(this.columns)) + "\r\n");
            this.initialized = true;
        }
    }

    public static void main(String[] args) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (CsvWriter w = new CsvWriter("c:\\temp\\test-output.csv", new String[]{"Col1", "Col2"});){
                w.writeLine(new String[]{"Hello, world", "Hi"});
                w.writeLine(new String[]{"12345", "Comma, test"});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioexc) {
            System.out.println("IOException: " + ioexc);
        }
    }
}

