/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;
import java.lang.reflect.Array;

enum ArrayVisitorFactory implements VisitorFactory<Object>
{
    INSTANCE;


    @Override
    public Visitor visitor(Object object) {
        if (object == null || !object.getClass().isArray()) {
            throw new IllegalArgumentException("Argument is not an array.");
        }
        return new ArrayVisitor(object);
    }

    private static final class ArrayVisitor
    implements Visitor {
        private final Object array;
        private final int length;
        private int index = -1;

        private ArrayVisitor(Object array) {
            this.array = array;
            this.length = Array.getLength(array);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length - 1;
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object value() {
            return Array.get(this.array, this.index);
        }
    }
}

