/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.JavaScriptObject;
import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;
import com.techempower.js.Visitors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JavaScriptWriter {
    private static final int CIRCULAR_REFERENCE_MIN_DEPTH = 10;
    private static final JavaScriptWriter STANDARD = new JavaScriptWriter(Collections.emptyMap());
    private final Map<Class<?>, VisitorFactory<?>> visitorFactories;
    private final List<Map.Entry<Class<?>, VisitorFactory<?>>> visitorFactoryEntries;

    public static JavaScriptWriter standard() {
        return STANDARD;
    }

    public static Builder custom() {
        return new Builder();
    }

    private static void requireNonNull(Object argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Argument \"" + name + "\" may not be null.");
        }
    }

    private static void stringify(Object object, Appendable out) throws IOException {
        String text = object.toString();
        out.append('\"');
        int i = 0;
        int length = text.length();
        while (i < length) {
            char c = text.charAt(i);
            switch (c) {
                case '\\': {
                    out.append("\\\\");
                    break;
                }
                case '\t': {
                    out.append("\\t");
                    break;
                }
                case '\b': {
                    out.append("\\b");
                    break;
                }
                case '\n': {
                    out.append("\\n");
                    break;
                }
                case '\r': {
                    out.append("\\r");
                    break;
                }
                case '\f': {
                    out.append("\\f");
                    break;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '=': 
                case '>': 
                case '\u2028': 
                case '\u2029': {
                    out.append(String.format("\\u%04x", c));
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f') {
                        out.append(String.format("\\u%04x", c));
                        break;
                    }
                    out.append(c);
                }
            }
            ++i;
        }
        out.append('\"');
    }

    public String write(Object object) {
        StringBuilder out = new StringBuilder();
        try {
            this.write(object, out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return out.toString();
    }

    public void write(Object object, Appendable out) throws IOException {
        JavaScriptWriter.requireNonNull(out, "out");
        this.write(object, out, 0, null);
    }

    private JavaScriptWriter(Map<Class<?>, VisitorFactory<?>> visitorFactories) {
        LinkedHashMap vf = new LinkedHashMap(visitorFactories);
        if (!vf.containsKey(Map.class)) {
            vf.put(Map.class, Visitors.forMaps());
        }
        if (!vf.containsKey(Iterable.class)) {
            vf.put(Iterable.class, Visitors.forIterables());
        }
        if (!vf.containsKey(Iterator.class)) {
            vf.put(Iterator.class, Visitors.forIterators());
        }
        if (!vf.containsKey(Enumeration.class)) {
            vf.put(Enumeration.class, Visitors.forEnumerations());
        }
        this.visitorFactories = Collections.unmodifiableMap(vf);
        this.visitorFactoryEntries = Collections.unmodifiableList(new ArrayList(this.visitorFactories.entrySet()));
    }

    private <T> VisitorFactory<T> getVisitorFactory(T object) {
        if (object.getClass().isArray()) {
            return Visitors.forArrays();
        }
        VisitorFactory<?> visitorFactory = this.visitorFactories.get(object.getClass());
        if (visitorFactory != null) {
            return visitorFactory;
        }
        if (object instanceof JavaScriptObject) {
            return ((JavaScriptObject)object).getJsVisitorFactory();
        }
        int i = 0;
        int size = this.visitorFactoryEntries.size();
        while (i < size) {
            Map.Entry<Class<?>, VisitorFactory<?>> entry = this.visitorFactoryEntries.get(i);
            if (entry.getKey().isInstance(object)) {
                return entry.getValue();
            }
            ++i;
        }
        return NullVisitorFactory.INSTANCE;
    }

    private void write(Object object, Appendable out, int depth, Set<Object> parents) throws IOException {
        Visitor visitor;
        if (object == null || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof Boolean) {
            out.append(String.valueOf(object));
            return;
        }
        if (object instanceof String || object instanceof Character) {
            JavaScriptWriter.stringify(object, out);
            return;
        }
        VisitorFactory<Object> visitorFactory = this.getVisitorFactory(object);
        if (visitorFactory == NullVisitorFactory.INSTANCE) {
            JavaScriptWriter.stringify(object, out);
            return;
        }
        Set<Object> localParents = parents;
        if (depth > 10) {
            if (localParents == null) {
                localParents = Collections.newSetFromMap(new IdentityHashMap());
            }
            if (!localParents.add(object)) {
                throw new IllegalArgumentException("Detected circular reference from object: " + object);
            }
        }
        if ((visitor = visitorFactory.visitor(object)).isArray()) {
            out.append('[');
            if (!visitor.hasNext()) {
                out.append(']');
                if (localParents != null) {
                    localParents.remove(object);
                }
                return;
            }
            visitor.next();
            this.write(visitor.value(), out, depth + 1, localParents);
            while (visitor.hasNext()) {
                visitor.next();
                out.append(',');
                this.write(visitor.value(), out, depth + 1, localParents);
            }
            out.append(']');
            if (localParents != null) {
                localParents.remove(object);
            }
            return;
        }
        out.append('{');
        if (!visitor.hasNext()) {
            out.append('}');
            if (localParents != null) {
                localParents.remove(object);
            }
            return;
        }
        visitor.next();
        JavaScriptWriter.stringify(visitor.name(), out);
        out.append(':');
        this.write(visitor.value(), out, depth + 1, localParents);
        while (visitor.hasNext()) {
            visitor.next();
            out.append(',');
            JavaScriptWriter.stringify(visitor.name(), out);
            out.append(':');
            this.write(visitor.value(), out, depth + 1, localParents);
        }
        out.append('}');
        if (localParents != null) {
            localParents.remove(object);
        }
    }

    /* synthetic */ JavaScriptWriter(Map map, JavaScriptWriter javaScriptWriter) {
        this(map);
    }

    public static class Builder {
        private static final Set<Class<?>> UNCUSTOMIZABLE_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.TYPE, Byte.TYPE, Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE, Boolean.class, Byte.class, Integer.class, Short.class, Long.class, Float.class, Double.class, Void.class, String.class)));
        private final LinkedHashMap<Class<?>, VisitorFactory<?>> visitorFactories = new LinkedHashMap();

        private static void requireCustomizableType(Class<?> type) {
            if (type.isArray() || UNCUSTOMIZABLE_TYPES.contains(type)) {
                throw new IllegalArgumentException("Rendering of type \"" + type + "\" cannot be customized.");
            }
        }

        private Builder() {
        }

        public <T> Builder addVisitorFactory(Class<? extends T> type, VisitorFactory<? extends T> visitorFactory) {
            JavaScriptWriter.requireNonNull(type, "type");
            JavaScriptWriter.requireNonNull(visitorFactory, "visitorFactory");
            Builder.requireCustomizableType(type);
            this.visitorFactories.put(type, visitorFactory);
            return this;
        }

        public Builder renderAsStrings(Class<?> type) {
            JavaScriptWriter.requireNonNull(type, "type");
            Builder.requireCustomizableType(type);
            this.visitorFactories.put(type, NullVisitorFactory.INSTANCE);
            return this;
        }

        public JavaScriptWriter build() {
            return this.visitorFactories.isEmpty() ? STANDARD : new JavaScriptWriter(this.visitorFactories, null);
        }
    }

    private static enum NullVisitorFactory implements VisitorFactory<Object>
    {
        INSTANCE;


        @Override
        public Visitor visitor(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

