/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;
import java.util.Iterator;
import java.util.Map;

enum MapVisitorFactory implements VisitorFactory<Object>
{
    INSTANCE;


    @Override
    public Visitor visitor(Object object) {
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("Argument is not a map.");
        }
        return new MapEntryIteratorVisitor(((Map)object).entrySet().iterator());
    }

    private static final class MapEntryIteratorVisitor<K, V>
    implements Visitor {
        private final Iterator<Map.Entry<K, V>> iterator;
        private Map.Entry<K, V> entry;

        private MapEntryIteratorVisitor(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public String name() {
            return String.valueOf(this.entry.getKey());
        }

        @Override
        public void next() {
            this.entry = this.iterator.next();
        }

        @Override
        public Object value() {
            return this.entry.getValue();
        }
    }
}

