/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.js;

import com.techempower.js.ArrayVisitorFactory;
import com.techempower.js.EnumerationVisitorFactory;
import com.techempower.js.IterableVisitorFactory;
import com.techempower.js.IteratorVisitorFactory;
import com.techempower.js.MapVisitorFactory;
import com.techempower.js.ReflectiveVisitorFactory;
import com.techempower.js.Visitor;
import com.techempower.js.VisitorFactory;

public final class Visitors {
    private Visitors() {
    }

    public static VisitorFactory<Object> forArrays() {
        return ArrayVisitorFactory.INSTANCE;
    }

    public static VisitorFactory<Object> forEnumerations() {
        return EnumerationVisitorFactory.INSTANCE;
    }

    public static VisitorFactory<Object> forIterators() {
        return IteratorVisitorFactory.INSTANCE;
    }

    public static VisitorFactory<Object> forIterables() {
        return IterableVisitorFactory.INSTANCE;
    }

    public static VisitorFactory<Object> forMaps() {
        return MapVisitorFactory.INSTANCE;
    }

    public static <T> VisitorFactory<T> forClass(Class<T> clazz, String ... namesAndMethods) {
        return new ReflectiveVisitorFactory<T>(clazz, namesAndMethods);
    }

    public static Visitor map(Object ... namesAndValues) {
        if (namesAndValues == null) {
            throw new IllegalArgumentException("Argument 'namesAndValues' must not be null.");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("Argument 'namesAndValues' must have an even number of elements.");
        }
        return new ArrayBackedMapVisitor(namesAndValues);
    }

    private static final class ArrayBackedMapVisitor
    implements Visitor {
        private final Object[] namesAndValues;
        private int index = -2;

        ArrayBackedMapVisitor(Object[] namesAndValues) {
            this.namesAndValues = namesAndValues;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.namesAndValues.length - 2;
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public String name() {
            if (this.index < 0) {
                throw new IllegalStateException("name() called before next()");
            }
            return String.valueOf(this.namesAndValues[this.index]);
        }

        @Override
        public void next() {
            if (!this.hasNext()) {
                throw new IllegalStateException("next() called when hasNext() was false");
            }
            this.index += 2;
        }

        @Override
        public Object value() {
            if (this.index < 0) {
                throw new IllegalStateException("value() called before next()");
            }
            return this.namesAndValues[this.index + 1];
        }
    }
}

