/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.TechEmpowerApplication;
import com.techempower.Version;
import com.techempower.log.AbstractLogListener;
import com.techempower.log.ComponentLog;
import com.techempower.log.ConsoleLogListener;
import com.techempower.log.FileLogListener;
import com.techempower.log.Log;
import com.techempower.log.LogItem;
import com.techempower.log.LogListener;
import com.techempower.util.EnhancedProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BasicLog
extends AbstractLogListener
implements Log {
    private static Log applicationLog;
    private CopyOnWriteArrayList<LogListener> logListeners = new CopyOnWriteArrayList();
    private List<LogItem> preConfigMessages = Collections.synchronizedList(new ArrayList());
    private boolean configured = false;
    private ConsoleLogListener consoleLog = new ConsoleLogListener(this.getApplication(), 0);
    private FileLogListener fileLog;

    public BasicLog(TechEmpowerApplication a) {
        super(a);
        this.addListener(this.consoleLog);
        applicationLog = this;
    }

    @Override
    public String getName() {
        return "Basic Log";
    }

    @Override
    public void configure(EnhancedProperties props, Version version) {
        this.setDebugThreshold(props.getIntegerProperty("Log.LogDebugThreshold", this.getDebugThreshold()));
        CopyOnWriteArrayList<AbstractLogListener> listeners = new CopyOnWriteArrayList<AbstractLogListener>();
        if (props.getYesNoProperty("Log.File.On", false)) {
            int fileDebugThreshold = props.getIntegerProperty("Log.File.LogDebugThreshold", this.getDebugThreshold());
            String logDirectory = props.getProperty("Log.File.LogDirectory", "logs");
            String logFilenamePrefix = props.getProperty("Log.File.LogFilenamePrefix", "");
            String logFilenameSuffix = props.getProperty("Log.File.LogFilenameSuffix", "");
            if (!props.isDefined("Log.File.LogDirectory")) {
                System.out.println("logf: No log directory has been specified.  Using default.");
                System.out.println("logf: Default log directory: " + logDirectory);
            } else {
                File logDirectoryFile = new File(logDirectory);
                if (!(logDirectoryFile.exists() && logDirectoryFile.isDirectory() || logDirectoryFile.mkdirs())) {
                    System.out.println("logf: Log directory missing and cannot be created.");
                }
            }
            this.fileLog = new FileLogListener(this.getApplication(), logDirectory, logFilenamePrefix, logFilenameSuffix, fileDebugThreshold);
            listeners.add(this.fileLog);
        }
        if (props.getYesNoProperty("Log.Console.On", false)) {
            int consoleDebugThreshold = props.getIntegerProperty("Log.Console.LogDebugThreshold", this.getDebugThreshold());
            this.consoleLog = new ConsoleLogListener(this.getApplication(), consoleDebugThreshold);
            listeners.add(this.consoleLog);
        }
        this.logListeners = listeners;
        this.log("logf", "Log successfully configured.");
        this.configured = true;
        this.writePreConfigMessages();
    }

    @Override
    public ComponentLog getComponentLog(String componentCode) {
        return new ComponentLog(this, componentCode);
    }

    public static Log getInstance() {
        return applicationLog;
    }

    private void writePreConfigMessages() {
        if (this.preConfigMessages != null && this.preConfigMessages.size() > 0) {
            boolean reAddConsoleLog = false;
            if (this.consoleLog != null) {
                reAddConsoleLog = this.logListeners.contains(this.consoleLog);
                this.removeListener(this.consoleLog);
            }
            for (LogItem item : this.preConfigMessages) {
                int type = item.getType();
                if (type == 1) {
                    this.log(item.getComponentCode(), item.getLogString(), item.getLevel());
                    continue;
                }
                if (type != 2) continue;
                this.assertion(item.getComponentCode(), true, item.getLogString(), item.getLevel());
            }
            if (reAddConsoleLog) {
                this.addListener(this.consoleLog);
            }
        }
        this.preConfigMessages = null;
    }

    @Override
    @Deprecated
    public void debug(String componentCode, String logString, int logLevel) {
        this.log(componentCode, logString, logLevel);
    }

    @Override
    public void log(String componentCode, String logString, int logLevel) {
        if (!this.configured && this.preConfigMessages != null) {
            this.preConfigMessages.add(new LogItem(componentCode, logString, 1, logLevel));
        }
        for (LogListener ll : this.getListeners()) {
            ll.log(componentCode, logString, logLevel);
        }
    }

    @Override
    public void assertion(String componentCode, boolean eval, String logString, int logLevel) {
        if (!eval && !this.configured && this.preConfigMessages != null) {
            this.preConfigMessages.add(new LogItem(componentCode, logString, 2, logLevel));
        }
        for (LogListener ll : this.getListeners()) {
            ll.assertion(componentCode, eval, logString, logLevel);
        }
    }

    protected List<LogListener> getListeners() {
        return this.logListeners;
    }

    @Override
    public List<LogListener> getLogListeners() {
        return new ArrayList<LogListener>(this.logListeners);
    }

    @Override
    public void addListener(LogListener listener) {
        this.logListeners.add(listener);
    }

    @Override
    public boolean removeListener(LogListener listener) {
        return this.logListeners.remove(listener);
    }
}

