/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.log;

import com.techempower.TechEmpowerApplication;
import com.techempower.helper.DateHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.AbstractLogListener;
import com.techempower.log.LogWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FileLogListener
extends AbstractLogListener
implements LogWriter {
    public static final int ITEM_BUFFER_MARGIN = 40;
    public static final String DEFAULT_LOGFILE_DIR = "logs";
    public static final String DEFAULT_LOGFILE_EXT = ".log";
    public static final String DEFAULT_LOGFILE = "log.log";
    public static final String DEFAULT_LOGFILE_PREFIX = "";
    public static final String DEFAULT_LOGFILE_SUFFIX = "";
    private String logFilenamePre = "";
    private String logFilenameSuf = "";
    private String logFilename = "log.log";
    private String logDirectory = "logs" + File.separator;
    private FileWriter fileWriter = null;
    private final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue();

    public FileLogListener(TechEmpowerApplication application, String directory, String filenamePrefix, String filenameSuffix, int threshold) {
        super(application);
        this.logFilename = this.generateFilename();
        this.setLogfileDirectory(directory);
        this.setLogFilenamePrefix(filenamePrefix);
        this.setLogFilenameSuffix(filenameSuffix);
        this.setDebugThreshold(threshold);
        application.getLogManager().addLogWriter(this, String.valueOf(application.getVersion().getProductName()) + " debug log");
    }

    @Override
    public String getName() {
        return "File Log";
    }

    @Override
    public void log(String componentCode, String logString, int debugLevel) {
        if (debugLevel >= this.getDebugThreshold()) {
            String toLog = StringHelper.stripISOControlCharacters(logString, " ");
            this.computeTimestamps();
            StringBuilder buffer = new StringBuilder(40 + toLog.length());
            buffer.append(this.getApplication().getVersion().getProductCode());
            buffer.append(' ');
            buffer.append(this.getFullTimestamp());
            buffer.append(' ');
            buffer.append(componentCode);
            buffer.append(": ");
            buffer.append(toLog);
            buffer.append("\r\n");
            this.queue.add(buffer.toString());
        }
    }

    @Override
    public void closeFile() {
        try {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
        catch (IOException ioexc) {
            this.debug("logf", "IOException while closing log file!");
        }
        this.fileWriter = null;
    }

    @Override
    public void closeFile(String statement) {
        this.closeFile();
    }

    @Override
    public boolean isOpen() {
        return this.fileWriter != null;
    }

    private void setLogFilenamePrefix(String prefixString) {
        this.logFilenamePre = prefixString;
    }

    private void setLogFilenameSuffix(String suffixString) {
        this.logFilenameSuf = suffixString;
    }

    private void setLogfileDirectory(String dir) {
        this.logDirectory = dir.endsWith(File.separator) ? dir : String.valueOf(dir) + File.separator;
    }

    private boolean needNewFile() {
        return super.pastEndOfDay();
    }

    @Override
    public boolean flushFile() {
        String logItem = this.queue.poll();
        if (logItem != null) {
            if (this.needNewFile()) {
                this.logFilename = this.generateFilename();
                this.closeFile();
                this.debug("logf", "New log file: " + this.logFilename);
            }
            if (this.fileWriter == null) {
                this.openFile(String.valueOf(this.logDirectory) + this.logFilename);
            }
            if (this.fileWriter != null) {
                try {
                    while (logItem != null) {
                        this.fileWriter.write(logItem);
                        logItem = this.queue.poll();
                    }
                    this.fileWriter.flush();
                    return true;
                }
                catch (IOException ioexc) {
                    System.out.println("Cannot write to log file. " + ioexc);
                }
            }
        }
        return false;
    }

    private void openFile(String filename) {
        try {
            this.fileWriter = new FileWriter(filename, true);
        }
        catch (IOException ioexc) {
            System.out.println("logfCannot open log: " + filename);
        }
    }

    private String generateFilename() {
        Calendar fnCal = DateHelper.getCalendarInstance();
        StringBuilder buffer = new StringBuilder(30);
        buffer.append(this.logFilenamePre);
        buffer.append(StringHelper.padZero(fnCal.get(1), 4));
        buffer.append('-');
        buffer.append(StringHelper.padZero(fnCal.get(2) + 1, 2));
        buffer.append('-');
        buffer.append(StringHelper.padZero(fnCal.get(5), 2));
        buffer.append(this.logFilenameSuf);
        buffer.append(DEFAULT_LOGFILE_EXT);
        return buffer.toString();
    }
}

