/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.thread.EndableThread;

public class EventRunnerThread
extends EndableThread {
    private static final ThreadLocal<EventRunnerThread> CURRENT_THREAD = new ThreadLocal();
    private final ScheduledEvent event;
    private final Scheduler scheduler;
    private final boolean onDemandExecution;

    public EventRunnerThread(ScheduledEvent event, Scheduler scheduler, boolean onDemandExecution) {
        super("Event Runner (" + event.getName() + ")");
        this.setPriority(1);
        this.event = event;
        this.scheduler = scheduler;
        this.onDemandExecution = onDemandExecution;
    }

    @Override
    public void run() {
        this.setStartTime();
        CURRENT_THREAD.set(this);
        try {
            try {
                this.event.execute(this.scheduler, this.onDemandExecution);
            }
            catch (Exception exc) {
                this.scheduler.getLog().log("Exception while executing (new thread) " + this.event, exc);
                this.event.setExecuting(false);
            }
            catch (Error error) {
                this.scheduler.getLog().log("Error while executing (new thread) " + this.event, error);
                this.event.setExecuting(false);
            }
        }
        finally {
            this.event.setExecuting(false);
        }
    }

    public static EventRunnerThread getCurrentThread() {
        return CURRENT_THREAD.get();
    }
}

