/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.TechEmpowerApplication;
import com.techempower.asynchronous.Asynchronous;
import com.techempower.helper.DateHelper;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import com.techempower.log.ComponentLog;
import com.techempower.scheduler.EventRunnerThread;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.SchedulerThread;
import com.techempower.util.Configurable;
import com.techempower.util.EnhancedProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Scheduler
implements Asynchronous,
Configurable {
    public static final String COMPONENT_CODE = "schd";
    public static final int DEFAULT_SLEEP_TIME = 5000;
    public static final int MINIMUM_SLEEP_TIME_SECONDS = 0;
    public static final int MAXIMUM_SLEEP_TIME_SECONDS = 600;
    private final TechEmpowerApplication application;
    private final ComponentLog log;
    private final List<ScheduledEvent> scheduledEvents = new ArrayList<ScheduledEvent>();
    private final SchedulerThread schedulerThread;
    private long sleepTime = 5000L;
    private boolean schedulerEnabled = true;

    public Scheduler(TechEmpowerApplication application) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.schedulerThread = new SchedulerThread(this);
        application.addAsynchronous(this);
    }

    @Override
    public void configure(EnhancedProperties props) {
        this.setSleepTime(props.getIntegerProperty("SchedulerSleepSeconds", (int)(this.getSleepTime() * 1000L)));
        this.setEnabled(props.getYesNoProperty("SchedulerEnabled", true));
    }

    protected ComponentLog getLog() {
        return this.log;
    }

    public synchronized void scheduleEvent(ScheduledEvent event, Date whenToInvoke) {
        this.scheduleEvent(event, whenToInvoke.getTime());
    }

    public synchronized void scheduleEvent(ScheduledEvent event, long whenToInvoke) {
        event.setScheduledTime(whenToInvoke);
        if (this.scheduledEvents.contains(event)) {
            this.log.log(event + " rescheduled for " + DateHelper.STANDARD_TECH_FORMAT.format(new Date(whenToInvoke)));
        } else {
            this.scheduledEvents.add(event);
            this.log.log(event + " scheduled for " + DateHelper.STANDARD_TECH_FORMAT.format(new Date(whenToInvoke)));
        }
    }

    public synchronized void scheduleEvent(ScheduledEvent event) {
        this.scheduleEvent(event, new Date(event.getDefaultScheduledTime()));
    }

    public synchronized void clear() {
        this.scheduledEvents.clear();
    }

    public synchronized void removeEvent(ScheduledEvent event) {
        this.scheduledEvents.remove(event);
    }

    public synchronized List<ScheduledEvent> getEvents() {
        return new ArrayList<ScheduledEvent>(this.scheduledEvents);
    }

    public synchronized ScheduledEvent getEvent(int index) {
        if (index >= 0 && index < this.scheduledEvents.size()) {
            return this.scheduledEvents.get(index);
        }
        return null;
    }

    public synchronized boolean isRunning() {
        return this.schedulerThread != null;
    }

    public synchronized SchedulerThread getSchedulerThread() {
        return this.schedulerThread;
    }

    @Override
    public synchronized void end() {
        this.schedulerThread.setKeepRunning(false);
    }

    @Override
    public synchronized void begin() {
        this.schedulerThread.start();
    }

    public TechEmpowerApplication getApplication() {
        return this.application;
    }

    public boolean isEnabled() {
        return this.schedulerEnabled;
    }

    public void setEnabled(boolean schedulerEnabled) {
        this.schedulerEnabled = schedulerEnabled;
        if (!schedulerEnabled) {
            this.log.log("Scheduler disabled.  No events will run.");
        } else {
            this.log.log("Scheduler enabled.");
        }
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int seconds) {
        int newSeconds = NumberHelper.boundInteger(seconds, 0, 600);
        this.sleepTime = (long)newSeconds * 1000L;
        this.log.log("Sleep time set to " + newSeconds + " second" + StringHelper.pluralize(newSeconds) + ".");
    }

    public void checkSchedule() {
        if (this.isEnabled()) {
            long now = System.currentTimeMillis();
            List<ScheduledEvent> events = this.getEvents();
            Iterator<ScheduledEvent> iter = events.iterator();
            while (iter.hasNext() && this.isEnabled()) {
                ScheduledEvent event = iter.next();
                if (!event.isEnabled() || event.isExecuting() || event.getScheduledTime() > now) continue;
                if (event.requiresOwnThread()) {
                    this.executeEventNewThread(event, false);
                    continue;
                }
                this.executeEventCurrentThread(event, false);
            }
        }
    }

    public boolean executeEventNewThread(ScheduledEvent event, boolean onDemandExecution) {
        if (!event.isExecuting()) {
            event.setExecuting(true);
            this.log.log("Executing " + event.getName() + " on new thread.");
            EventRunnerThread ert = new EventRunnerThread(event, this, onDemandExecution);
            ert.start();
            return true;
        }
        return false;
    }

    public boolean executeEventCurrentThread(ScheduledEvent event, boolean onDemandExecution) {
        if (!event.isExecuting()) {
            event.setExecuting(true);
            this.log.log("Executing " + event);
            try {
                try {
                    event.execute(this, onDemandExecution);
                }
                catch (Exception exc) {
                    this.log.log("Exception while executing " + event, exc);
                    event.setExecuting(false);
                    return false;
                }
                catch (Error error) {
                    this.log.log("Error while executing " + event, error);
                    event.setExecuting(false);
                    return false;
                }
            }
            finally {
                event.setExecuting(false);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "[Scheduler: " + this.scheduledEvents.size() + " event(s)]";
    }
}

