/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.scheduler;

import com.techempower.helper.DateHelper;
import com.techempower.scheduler.ScheduledEvent;
import com.techempower.scheduler.Scheduler;
import com.techempower.util.Args;
import java.util.Calendar;

public abstract class WeeklyEvent
extends ScheduledEvent {
    private final int hour;
    private final int minute;
    private final int day;

    public WeeklyEvent(String name, String description, int hour, int minute, int day) {
        this.setName(name);
        this.setDescription(description);
        Args.intBound(minute, "minute", 0, 59);
        Args.intBound(hour, "hour", 0, 23);
        Args.intBound(day, "day", 0, 6);
        this.hour = hour;
        this.minute = minute;
        this.day = day;
    }

    @Override
    public long getDefaultScheduledTime() {
        return this.getNextRun().getTimeInMillis();
    }

    protected Calendar getNextRun() {
        Calendar cal = DateHelper.getCalendarInstance();
        cal.add(5, 1);
        int dayOfWeek = cal.get(7);
        while (dayOfWeek != this.day + 1) {
            cal.add(5, 1);
            dayOfWeek = cal.get(7);
        }
        cal.set(11, this.hour);
        cal.set(12, this.minute);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    @Override
    public void execute(Scheduler scheduler) {
        this.doIt();
        Calendar nextRun = this.getNextRun();
        scheduler.scheduleEvent((ScheduledEvent)this, nextRun.getTimeInMillis());
    }

    protected abstract void doIt();
}

