/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.security;

import com.techempower.helper.StringHelper;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SimpleDigester {
    public static final int MD5_LENGTH = 32;
    public static final int HEXADECIMAL = 16;
    private MessageDigest shaDigest;
    private MessageDigest md5Digest;

    protected synchronized MessageDigest getMd5Digester() {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.md5Digest;
    }

    protected synchronized MessageDigest getShaDigester() {
        if (this.shaDigest == null) {
            try {
                this.shaDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.shaDigest;
    }

    public synchronized String getMD5(String sourceString) {
        MessageDigest digest = this.getMd5Digester();
        byte[] results = digest.digest(sourceString.getBytes());
        digest.reset();
        return new String(results);
    }

    public synchronized String getMD5Hex(String source) {
        byte[] bytesOfMessage = source.getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = this.getMd5Digester();
        digest.reset();
        digest.update(bytesOfMessage);
        byte[] digestArray = digest.digest();
        BigInteger bigInt = new BigInteger(1, digestArray);
        String hashText = bigInt.toString(16);
        return StringHelper.padZero(hashText, 32);
    }

    public synchronized String getSHA(String sourceString) {
        MessageDigest digest = this.getShaDigester();
        byte[] results = digest.digest(sourceString.getBytes());
        digest.reset();
        return new String(results);
    }

    public synchronized byte[] getSHAAsByteArray(String sourceString) {
        MessageDigest digest = this.getShaDigester();
        byte[] results = digest.digest(sourceString.getBytes());
        digest.reset();
        return results;
    }

    public synchronized String getSHAHex(String sourceString) {
        byte[] bytesOfMessage = sourceString.getBytes(StandardCharsets.UTF_8);
        MessageDigest digest = this.getShaDigester();
        BigInteger result = new BigInteger(1, digest.digest(bytesOfMessage));
        digest.reset();
        return result.toString(16);
    }

    public static void main(String[] args) {
        SimpleDigester sd = new SimpleDigester();
        System.out.println("Simple digester.  " + args.length + " arguments.");
        int i = 0;
        while (i < args.length) {
            System.out.println(String.valueOf(args[i]) + "  MD5: " + sd.getMD5Hex(args[i]) + "  SHA: " + sd.getSHAHex(args[i]));
            ++i;
        }
    }
}

