/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.text;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SynchronizedSimpleDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -3607754024638244107L;

    public SynchronizedSimpleDateFormat(String format) {
        super(format);
    }

    public SynchronizedSimpleDateFormat() {
        this("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public String format(Date date, String defaultValueWhenNull) {
        if (date == null) {
            return defaultValueWhenNull;
        }
        return this.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date, TimeZone tz) {
        SynchronizedSimpleDateFormat synchronizedSimpleDateFormat = this;
        synchronized (synchronizedSimpleDateFormat) {
            TimeZone origTimeZone = this.getTimeZone();
            if (origTimeZone == null) {
                origTimeZone = TimeZone.getDefault();
            }
            if (tz != null) {
                this.setTimeZone(tz);
            }
            String toReturn = super.format(date);
            if (tz != null) {
                this.setTimeZone(origTimeZone);
            }
            return toReturn;
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(date, toAppendTo, pos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos, TimeZone tz) {
        SynchronizedSimpleDateFormat synchronizedSimpleDateFormat = this;
        synchronized (synchronizedSimpleDateFormat) {
            TimeZone origTimeZone = this.getTimeZone();
            if (origTimeZone == null) {
                origTimeZone = TimeZone.getDefault();
            }
            if (tz != null) {
                this.setTimeZone(tz);
            }
            StringBuffer toReturn = super.format(date, toAppendTo, pos);
            if (tz != null) {
                this.setTimeZone(origTimeZone);
            }
            return toReturn;
        }
    }

    public Date parse(String source, TimeZone tz) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(source, pos, tz);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable date: \"" + source + "\"", pos.getErrorIndex());
        }
        return result;
    }

    @Override
    public Date parse(String source) throws ParseException {
        return this.parse(source, new ParsePosition(0));
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        return this.parse(source, pos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String source, ParsePosition pos, TimeZone tz) {
        SynchronizedSimpleDateFormat synchronizedSimpleDateFormat = this;
        synchronized (synchronizedSimpleDateFormat) {
            TimeZone origTimeZone = this.getTimeZone();
            if (origTimeZone == null) {
                origTimeZone = TimeZone.getDefault();
            }
            if (tz != null) {
                this.setTimeZone(tz);
            }
            Date toReturn = super.parse(source, pos);
            if (tz != null) {
                this.setTimeZone(origTimeZone);
            }
            return toReturn;
        }
    }

    public String toString() {
        return super.toPattern();
    }
}

