/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.thread;

import com.techempower.asynchronous.Asynchronous;

public class EndableThread
extends Thread
implements Asynchronous {
    public static final int DEFAULT_MAXIMUM_SLEEP = 10000;
    public static final int DEFAULT_MINIMUM_SLEEP = 500;
    public static final int DEFAULT_SLEEP_ADJUSTMENT = 500;
    public static final int DEFAULT_SLEEP_PERIOD = 1000;
    private volatile boolean running = true;
    private volatile boolean paused = false;
    private final int maxSleep;
    private final int minSleep;
    private final int sleepAdjustment;
    private boolean sleeping = false;
    private boolean pauseChecked = false;
    private int sleepPeriod = 1000;
    private long startTime = 0L;
    private long stopTime = 0L;

    public EndableThread(String name, int sleepPeriod, int maxSleep, int minSleep, int sleepAdjustment) {
        super(name);
        this.sleepPeriod = sleepPeriod;
        this.maxSleep = maxSleep;
        this.minSleep = minSleep;
        this.sleepAdjustment = sleepAdjustment;
    }

    public EndableThread(int sleepPeriod, int maxSleep, int minSleep, int sleepAdjustment) {
        this("Endable Thread", sleepPeriod, maxSleep, minSleep, sleepAdjustment);
    }

    public EndableThread(String name, int sleepPeriod) {
        this(name, sleepPeriod, 10000, 500, 500);
    }

    public EndableThread(String name) {
        this(name, 1000);
    }

    public EndableThread() {
        this("Endable thread");
    }

    public void setKeepRunning(boolean keepRunning) {
        this.running = keepRunning;
        this.interrupt();
        if (!keepRunning) {
            this.setStopTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        if (this.paused && !paused) {
            EndableThread endableThread = this;
            synchronized (endableThread) {
                this.paused = paused;
                this.pauseChecked = false;
                this.notifyAll();
            }
        } else {
            this.paused = paused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPause() {
        if (this.paused) {
            this.pauseChecked = true;
            try {
                while (this.paused) {
                    EndableThread endableThread = this;
                    synchronized (endableThread) {
                        if (this.paused) {
                            this.wait(10000L);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.isRunning();
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStopTime() {
        this.stopTime = System.currentTimeMillis();
    }

    public long getStopTime() {
        return this.stopTime;
    }

    protected int getMaxSleep() {
        return this.maxSleep;
    }

    public long getThreadLifetime() {
        if (this.getStopTime() >= this.getStartTime()) {
            return this.getStopTime() - this.getStartTime();
        }
        return System.currentTimeMillis() - this.getStartTime();
    }

    @Override
    public void begin() {
        if (this.getState() == Thread.State.NEW) {
            this.setStartTime();
            this.start();
        }
    }

    @Override
    public void end() {
        this.setKeepRunning(false);
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isPauseChecked() {
        return this.pauseChecked;
    }

    public boolean isAsleep() {
        return this.sleeping;
    }

    public int getSleepPeriod() {
        return this.sleepPeriod;
    }

    public void simpleSleep() {
        this.simpleSleep((long)this.sleepPeriod);
    }

    public void simpleSleep(int milliseconds) {
        this.simpleSleep((long)milliseconds);
    }

    public void simpleSleep(long milliseconds) {
        if (milliseconds > 0L) {
            this.sleeping = true;
            try {
                Thread.sleep(milliseconds);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sleeping = false;
        } else {
            Thread.yield();
        }
    }

    public void incrementSleep() {
        if (this.sleepPeriod < this.maxSleep) {
            this.sleepPeriod += this.sleepAdjustment;
            if (this.sleepPeriod > this.maxSleep) {
                this.sleepPeriod = this.maxSleep;
            }
        }
    }

    public void decrementSleep() {
        if (this.sleepPeriod > this.minSleep) {
            this.sleepPeriod -= this.sleepAdjustment;
            if (this.sleepPeriod < this.minSleep) {
                this.sleepPeriod = this.minSleep;
            }
        }
    }

    public void setMinimumSleep() {
        this.sleepPeriod = this.minSleep;
    }

    public void setMaximumSleep() {
        this.sleepPeriod = this.maxSleep;
    }
}

