/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.thread;

import com.techempower.helper.ThreadHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SimpleLatch {
    private final List<Runnable> runnables = new ArrayList<Runnable>();

    public SimpleLatch add(Runnable runnable) {
        this.runnables.add(runnable);
        return this;
    }

    public SimpleLatch addAll(List<Runnable> runnablesToAdd) {
        this.runnables.addAll(runnablesToAdd);
        return this;
    }

    public int size() {
        return this.runnables.size();
    }

    public SimpleLatch runAndWait() {
        return this.runAndWait(86400000L);
    }

    public SimpleLatch runAndWait(long timeoutMs) {
        final CountDownLatch cdl = new CountDownLatch(this.size());
        Iterator<Runnable> iterator = this.runnables.iterator();
        while (iterator.hasNext()) {
            Runnable r;
            final Runnable runnable = r = iterator.next();
            Runnable wrapped = new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    cdl.countDown();
                }
            };
            ThreadHelper.submit(wrapped);
        }
        try {
            cdl.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this;
    }
}

