/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.zipcode;

import com.techempower.zipcode.ZipCodeManager;

public class ZipCodeRange {
    private ZipCodeManager manager;
    private double latitudeMinimum = 0.0;
    private double latitudeCenter = 0.0;
    private double latitudeMaximum = 0.0;
    private double longitudeMinimum = 0.0;
    private double longitudeCenter = 0.0;
    private double longitudeMaximum = 0.0;

    protected ZipCodeRange(ZipCodeManager manager, double latitudeMin, double latitudeMax, double longitudeMin, double longitudeMax) {
        this.manager = manager;
        this.latitudeMinimum = latitudeMin;
        this.latitudeMaximum = latitudeMax;
        this.longitudeMinimum = longitudeMin;
        this.longitudeMaximum = longitudeMax;
        this.latitudeCenter = Math.abs((this.latitudeMaximum - this.latitudeMinimum) / 2.0);
        this.longitudeCenter = Math.abs((this.longitudeMaximum - this.longitudeMinimum) / 2.0);
    }

    protected ZipCodeRange(ZipCodeManager manager, double sourceLon, double sourceLat, int distanceInMiles) {
        this.manager = manager;
        double dLat = this.dLat(distanceInMiles);
        double dLon = this.dLon(sourceLat, distanceInMiles);
        this.latitudeMinimum = sourceLat - dLat / manager.getDeltaDivisor();
        this.latitudeMaximum = sourceLat + dLat / manager.getDeltaDivisor();
        this.longitudeMinimum = sourceLon - dLon / manager.getDeltaDivisor();
        this.longitudeMaximum = sourceLon + dLon / manager.getDeltaDivisor();
        this.latitudeCenter = Math.abs((this.latitudeMaximum - this.latitudeMinimum) / 2.0);
        this.longitudeCenter = Math.abs((this.longitudeMaximum - this.longitudeMinimum) / 2.0);
    }

    public String getWhereExpression() {
        return "((" + this.manager.getLatitudeColumn() + " BETWEEN " + this.getLatitudeMinimum() + " AND " + this.getLatitudeMaximum() + ") AND (" + this.manager.getLongitudeColumn() + " BETWEEN " + this.getLongitudeMinimum() + " AND " + this.getLongitudeMaximum() + "))";
    }

    public boolean isZipCodeWithinRange(ZipCodeRange aZipRange) {
        if (aZipRange == null) {
            return false;
        }
        return this.isZipCodeWithinRange(aZipRange.getLatitudeCenter(), aZipRange.getLongitudeCenter());
    }

    public boolean isZipCodeWithinRange(double givenLat, double givenLon) {
        return givenLat >= this.latitudeMinimum && givenLat <= this.latitudeMaximum && givenLon >= this.longitudeMinimum && givenLon <= this.longitudeMaximum;
    }

    public double getLatitudeMinimum() {
        return this.latitudeMinimum;
    }

    public double getLatitudeCenter() {
        return this.latitudeCenter;
    }

    public double getLatitudeMaximum() {
        return this.latitudeMaximum;
    }

    public double getLongitudeMinimum() {
        return this.longitudeMinimum;
    }

    public double getLongitudeCenter() {
        return this.longitudeCenter;
    }

    public double getLongitudeMaximum() {
        return this.longitudeMaximum;
    }

    public String toString() {
        return "ZipCodeRange [lat: " + this.getLatitudeMinimum() + " to " + this.getLatitudeMaximum() + "; lon: " + this.getLongitudeMinimum() + " to " + this.getLongitudeMaximum() + "]";
    }

    public double dLon(double sourceLat, int distanceInMiles) {
        double sourceLatRadians = Math.toRadians(sourceLat);
        double dLon = (double)distanceInMiles / (Math.cos(sourceLatRadians) * (double)this.manager.getRadiusOfEarth());
        return Math.abs(Math.toDegrees(dLon));
    }

    public double dLat(int distanceInMiles) {
        double dLat = (double)distanceInMiles / (double)this.manager.getRadiusOfEarth();
        return Math.abs(Math.toDegrees(dLat));
    }
}

