/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Compressor
extends Serializer {
    private Serializer serializer;
    private boolean compress = true;
    private boolean decompress = true;
    protected final int bufferSize;

    public Compressor(Serializer serializer) {
        this(serializer, 2048);
    }

    public Compressor(Serializer serializer, int n) {
        this.serializer = serializer;
        this.bufferSize = n;
    }

    public void setCompress(boolean bl) {
        this.compress = bl;
    }

    public void setDecompress(boolean bl) {
        this.decompress = bl;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        if (!this.compress) {
            this.serializer.writeObjectData(byteBuffer, object);
            return;
        }
        int n = byteBuffer.position() + 2;
        try {
            byteBuffer.position(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            new BufferOverflowException();
        }
        this.serializer.writeObjectData(byteBuffer, object);
        int n2 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.limit(n2);
        Context context = Kryo.getContext();
        ByteBuffer byteBuffer2 = context.getBuffer(this.bufferSize);
        this.compress(byteBuffer, object, byteBuffer2);
        byteBuffer2.flip();
        byteBuffer.position(n - 2);
        byteBuffer.limit(byteBuffer.capacity());
        byteBuffer.putShort((short)byteBuffer2.limit());
        byteBuffer.put(byteBuffer2);
        if (Log.TRACE) {
            Log.trace("kryo", "Compressed to " + (float)((int)((float)byteBuffer2.limit() / (float)(n2 - n) * 10000.0f)) / 100.0f + "% using: " + this.getClass().getName());
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        if (!this.decompress) {
            return this.serializer.readObjectData(byteBuffer, clazz);
        }
        int n = byteBuffer.limit();
        short s = byteBuffer.getShort();
        try {
            byteBuffer.limit(byteBuffer.position() + s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SerializationException("Compressed data length exceeds buffer capacity: " + byteBuffer.position() + s, illegalArgumentException);
        }
        Context context = Kryo.getContext();
        ByteBuffer byteBuffer2 = context.getBuffer(this.bufferSize);
        this.decompress(byteBuffer, clazz, byteBuffer2);
        byteBuffer2.flip();
        byteBuffer.limit(n);
        if (Log.TRACE) {
            Log.trace("kryo", "Decompressed using: " + this.getClass().getName());
        }
        return this.serializer.readObjectData(byteBuffer2, clazz);
    }

    public abstract void compress(ByteBuffer var1, Object var2, ByteBuffer var3);

    public abstract void decompress(ByteBuffer var1, Class var2, ByteBuffer var3);
}

