/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.CustomSerialization;
import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.ArraySerializer;
import com.esotericsoftware.kryo.serialize.BooleanSerializer;
import com.esotericsoftware.kryo.serialize.ByteSerializer;
import com.esotericsoftware.kryo.serialize.CharSerializer;
import com.esotericsoftware.kryo.serialize.CollectionSerializer;
import com.esotericsoftware.kryo.serialize.CustomSerializer;
import com.esotericsoftware.kryo.serialize.DoubleSerializer;
import com.esotericsoftware.kryo.serialize.EnumSerializer;
import com.esotericsoftware.kryo.serialize.FieldSerializer;
import com.esotericsoftware.kryo.serialize.FloatSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.kryo.serialize.LongSerializer;
import com.esotericsoftware.kryo.serialize.MapSerializer;
import com.esotericsoftware.kryo.serialize.ShortSerializer;
import com.esotericsoftware.kryo.serialize.StringSerializer;
import com.esotericsoftware.kryo.util.IntHashMap;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kryo {
    public static final String version = "1.03";
    private static final byte ID_NULL_OBJECT = 0;
    private static final int ID_CLASS_NAME = 16383;
    private static ThreadLocal<Context> contextThreadLocal = new ThreadLocal<Context>(){

        @Override
        protected Context initialValue() {
            return new Context();
        }
    };
    private final ConcurrentHashMap<Integer, RegisteredClass> idToRegisteredClass = new ConcurrentHashMap(64);
    private final ConcurrentHashMap<Class, RegisteredClass> classToRegisteredClass = new ConcurrentHashMap(64);
    private AtomicInteger nextClassID = new AtomicInteger(1);
    private Object listenerLock = new Object();
    private volatile Listener[] listeners = new Listener[0];
    private boolean registrationOptional;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private final CustomSerializer customSerializer = new CustomSerializer(this);
    private final ArraySerializer arraySerializer = new ArraySerializer(this);
    private final CollectionSerializer collectionSerializer = new CollectionSerializer(this);
    private final MapSerializer mapSerializer = new MapSerializer(this);

    public Kryo() {
        this.register(Boolean.TYPE, new BooleanSerializer());
        this.register(Byte.TYPE, new ByteSerializer());
        this.register(Character.TYPE, new CharSerializer());
        this.register(Short.TYPE, new ShortSerializer());
        this.register(Integer.TYPE, new IntSerializer());
        this.register(Long.TYPE, new LongSerializer());
        this.register(Float.TYPE, new FloatSerializer());
        this.register(Double.TYPE, new DoubleSerializer());
        this.register(Boolean.class, new BooleanSerializer());
        this.register(Byte.class, new ByteSerializer());
        this.register(Character.class, new CharSerializer());
        this.register(Short.class, new ShortSerializer());
        this.register(Integer.class, new IntSerializer());
        this.register(Long.class, new LongSerializer());
        this.register(Float.class, new FloatSerializer());
        this.register(Double.class, new DoubleSerializer());
        this.register(String.class, new StringSerializer());
    }

    public void setRegistrationOptional(boolean bl) {
        this.registrationOptional = bl;
    }

    public RegisteredClass register(Class clazz, Serializer serializer, boolean bl) {
        int n;
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (serializer == null) {
            throw new IllegalArgumentException("serializer cannot be null.");
        }
        if (clazz.isPrimitive()) {
            serializer.setCanBeNull(false);
        }
        RegisteredClass registeredClass = this.classToRegisteredClass.get(clazz);
        if (bl) {
            n = 16383;
        } else if (registeredClass != null) {
            n = registeredClass.id;
        } else {
            n = this.nextClassID.getAndIncrement();
            if (n == 16383) {
                n = this.nextClassID.getAndIncrement();
            }
        }
        RegisteredClass registeredClass2 = new RegisteredClass(clazz, n, serializer);
        if (!bl) {
            this.idToRegisteredClass.put(n, registeredClass2);
        }
        this.classToRegisteredClass.put(clazz, registeredClass2);
        if (Log.TRACE && n > 17) {
            String string = clazz.getName();
            if (clazz.isArray()) {
                Class clazz2 = ArraySerializer.getElementClass(clazz);
                StringBuilder stringBuilder = new StringBuilder(16);
                int n2 = ArraySerializer.getDimensionCount(clazz);
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append("[]");
                }
                string = clazz2.getName() + stringBuilder;
            }
            if (bl) {
                Log.trace("kryo", "Registered class name: " + string + " (" + serializer.getClass().getName() + ")");
            } else {
                Log.trace("kryo", "Registered class ID " + n + ": " + string + " (" + serializer.getClass().getName() + ")");
            }
        }
        return registeredClass2;
    }

    public RegisteredClass register(Class clazz, Serializer serializer) {
        return this.register(clazz, serializer, false);
    }

    public RegisteredClass register(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        RegisteredClass registeredClass = this.classToRegisteredClass.get(clazz);
        if (registeredClass != null && registeredClass.id >= 1 && registeredClass.id <= 17) {
            throw new IllegalArgumentException("Class is registered by default: " + clazz.getName());
        }
        return this.register(clazz, this.newSerializer(clazz));
    }

    public void register(Class clazz, RegisteredClass registeredClass) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (registeredClass == null) {
            throw new IllegalArgumentException("registeredClass cannot be null.");
        }
        this.classToRegisteredClass.put(clazz, registeredClass);
        if (Log.TRACE) {
            String string = clazz.getName();
            if (clazz.isArray()) {
                Class clazz2 = ArraySerializer.getElementClass(clazz);
                StringBuilder stringBuilder = new StringBuilder(16);
                int n = ArraySerializer.getDimensionCount(clazz);
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("[]");
                }
                string = clazz2.getName() + stringBuilder;
            }
            if (registeredClass.id == 16383) {
                Log.trace("kryo", "Registered class name: " + string + " (" + registeredClass.serializer.getClass().getName() + ")");
            } else {
                Log.trace("kryo", "Registered class ID " + registeredClass.id + ": " + string + " (" + registeredClass.serializer.getClass().getName() + ")");
            }
        }
    }

    public Serializer newSerializer(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (clazz.isArray()) {
            return this.arraySerializer;
        }
        if (CustomSerialization.class.isAssignableFrom(clazz)) {
            return this.customSerializer;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.collectionSerializer;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.mapSerializer;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumSerializer(clazz);
        }
        if (clazz.isAnnotationPresent(DefaultSerializer.class)) {
            Class<? extends Serializer> clazz2 = clazz.getAnnotation(DefaultSerializer.class).value();
            try {
                try {
                    return clazz2.getConstructor(Kryo.class, Class.class).newInstance(this, clazz);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        return clazz2.getConstructor(Kryo.class).newInstance(this);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        try {
                            return clazz2.getConstructor(Class.class).newInstance(this, clazz);
                        }
                        catch (NoSuchMethodException noSuchMethodException3) {
                            return clazz2.newInstance();
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Unable to create serializer \"" + clazz2.getName() + "\" for class: " + clazz.getName(), exception);
            }
        }
        return this.newDefaultSerializer(clazz);
    }

    protected Serializer newDefaultSerializer(Class clazz) {
        return new FieldSerializer(this, clazz);
    }

    public RegisteredClass getRegisteredClass(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        RegisteredClass registeredClass = this.classToRegisteredClass.get(clazz);
        if (registeredClass != null) {
            return registeredClass;
        }
        if (Proxy.isProxyClass(clazz)) {
            return this.getRegisteredClass(InvocationHandler.class);
        }
        if (!clazz.isEnum() && Enum.class.isAssignableFrom(clazz) && (registeredClass = this.classToRegisteredClass.get(clazz = clazz.getEnclosingClass())) != null) {
            return registeredClass;
        }
        if (this.registrationOptional) {
            this.handleUnregisteredClass(clazz);
            registeredClass = this.classToRegisteredClass.get(clazz);
            if (registeredClass != null) {
                return registeredClass;
            }
        }
        if (clazz.isArray()) {
            Class clazz2 = ArraySerializer.getElementClass(clazz);
            StringBuilder stringBuilder = new StringBuilder(16);
            int n = ArraySerializer.getDimensionCount(clazz);
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("[]");
            }
            throw new IllegalArgumentException("Class is not registered: " + clazz.getName() + "\nNote: To register this class use: kryo.register(" + clazz2.getName() + stringBuilder + ".class);");
        }
        throw new IllegalArgumentException("Class is not registered: " + clazz.getName());
    }

    protected void handleUnregisteredClass(Class clazz) {
        this.register(clazz, this.newSerializer(clazz), true);
    }

    public RegisteredClass getRegisteredClass(int n) {
        RegisteredClass registeredClass = this.idToRegisteredClass.get(n);
        if (registeredClass == null) {
            throw new IllegalArgumentException("Class ID is not registered: " + n);
        }
        return registeredClass;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Serializer getSerializer(Class clazz) {
        return this.getRegisteredClass((Class)clazz).serializer;
    }

    public void setSerializer(Class clazz, Serializer serializer) {
        this.getRegisteredClass((Class)clazz).serializer = serializer;
    }

    public RegisteredClass writeClass(ByteBuffer byteBuffer, Class clazz) {
        if (clazz == null) {
            try {
                byteBuffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return null;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new SerializationException("Buffer limit exceeded writing null object.", bufferOverflowException);
            }
        }
        try {
            RegisteredClass registeredClass = this.getRegisteredClass(clazz);
            IntSerializer.put(byteBuffer, registeredClass.id, true);
            if (registeredClass.id == 16383) {
                Integer n;
                Context context = Kryo.getContext();
                ClassReferences classReferences = (ClassReferences)context.getTemp("classReferences");
                if (classReferences == null) {
                    classReferences = (ClassReferences)context.get("classReferences");
                    if (classReferences == null) {
                        classReferences = new ClassReferences();
                        context.put("classReferences", classReferences);
                    } else {
                        classReferences.reset();
                    }
                    context.putTemp("classReferences", classReferences);
                }
                if ((n = classReferences.classToReference.get(clazz)) != null) {
                    IntSerializer.put(byteBuffer, n, true);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Wrote class name reference " + n + ": " + clazz.getName());
                    }
                    return registeredClass;
                }
                byteBuffer.put((byte)0);
                classReferences.classToReference.put(clazz, classReferences.referenceCount++);
                StringSerializer.put(byteBuffer, clazz.getName());
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote class name: " + clazz.getName());
                }
            } else if (Log.TRACE) {
                Log.trace("kryo", "Wrote class " + registeredClass.id + ": " + clazz.getName());
            }
            return registeredClass;
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing class ID: " + clazz, serializationException);
            }
            throw serializationException;
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new SerializationException("Buffer limit exceeded writing class ID: " + clazz, bufferOverflowException);
        }
    }

    public RegisteredClass readClass(ByteBuffer byteBuffer) {
        int n;
        block18: {
            try {
                Class<?> clazz;
                int n2;
                n = IntSerializer.get(byteBuffer, true);
                if (n == 0) {
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read object: null");
                    }
                    return null;
                }
                if (n != 16383) break block18;
                Context context = Kryo.getContext();
                ClassReferences classReferences = (ClassReferences)context.getTemp("classReferences");
                if (classReferences == null) {
                    classReferences = (ClassReferences)context.get("classReferences");
                    if (classReferences == null) {
                        classReferences = new ClassReferences();
                        context.put("classReferences", classReferences);
                    } else {
                        classReferences.reset();
                    }
                    context.putTemp("classReferences", classReferences);
                }
                if ((n2 = IntSerializer.get(byteBuffer, true)) != 0) {
                    clazz = (Class<?>)classReferences.referenceToClass.get(n2);
                    if (clazz == null) {
                        throw new SerializationException("Invalid class name reference: " + n2);
                    }
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read class name reference " + n2 + ": " + clazz.getName());
                    }
                } else {
                    String string = StringSerializer.get(byteBuffer);
                    if (Log.TRACE) {
                        Log.trace("kryo", "Read class name: " + string);
                    }
                    try {
                        clazz = Class.forName(string, false, this.classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new SerializationException("Unable to find class: " + string, classNotFoundException);
                    }
                    classReferences.referenceToClass.put(classReferences.referenceCount++, clazz);
                }
                return this.getRegisteredClass(clazz);
            }
            catch (SerializationException serializationException) {
                if (serializationException.causedBy(BufferUnderflowException.class)) {
                    throw new SerializationException("Buffer limit exceeded reading class ID.", serializationException);
                }
                throw serializationException;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                throw new SerializationException("Buffer limit exceeded reading class ID.", bufferUnderflowException);
            }
        }
        RegisteredClass registeredClass = this.idToRegisteredClass.get(n);
        if (registeredClass == null) {
            throw new SerializationException("Encountered unregistered class ID: " + n);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read class " + n + ": " + registeredClass.type.getName());
        }
        return registeredClass;
    }

    public void writeClassAndObject(ByteBuffer byteBuffer, Object object) {
        if (object == null) {
            try {
                byteBuffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new SerializationException("Buffer limit exceeded writing null object.", bufferOverflowException);
            }
        }
        RegisteredClass registeredClass = this.writeClass(byteBuffer, object.getClass());
        if (registeredClass == null) {
            return;
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            registeredClass.serializer.writeObjectData(byteBuffer, object);
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), serializationException);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), serializationException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), bufferOverflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public void writeObject(ByteBuffer byteBuffer, Object object) {
        if (object == null) {
            try {
                byteBuffer.put((byte)0);
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new SerializationException("Buffer limit exceeded writing null object.", bufferOverflowException);
            }
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            this.getRegisteredClass(object.getClass()).serializer.writeObject(byteBuffer, object);
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), serializationException);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), serializationException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), bufferOverflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            this.getRegisteredClass(object.getClass()).serializer.writeObjectData(byteBuffer, object);
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferOverflowException.class)) {
                throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), serializationException);
            }
            throw new SerializationException("Unable to serialize object of type: " + object.getClass().getName(), serializationException);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw new SerializationException("Buffer limit exceeded writing object of type: " + object.getClass().getName(), bufferOverflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public Object readClassAndObject(ByteBuffer byteBuffer) {
        RegisteredClass registeredClass = this.readClass(byteBuffer);
        if (registeredClass == null) {
            return null;
        }
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            Object t = registeredClass.serializer.readObjectData(byteBuffer, registeredClass.type);
            return t;
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + registeredClass.type.getName(), serializationException);
            }
            throw new SerializationException("Unable to deserialize object of type: " + registeredClass.type.getName(), serializationException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + registeredClass.type.getName(), bufferUnderflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public <T> T readObject(ByteBuffer byteBuffer, Class<T> clazz) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            T t = this.getRegisteredClass(clazz).serializer.readObject(byteBuffer, clazz);
            return t;
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + clazz.getName(), serializationException);
            }
            throw new SerializationException("Unable to deserialize object of type: " + clazz.getName(), serializationException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + clazz.getName(), bufferUnderflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        Context context = Kryo.getContext();
        ++context.objectGraphLevel;
        try {
            T t = this.getRegisteredClass(clazz).serializer.readObjectData(byteBuffer, clazz);
            return t;
        }
        catch (SerializationException serializationException) {
            if (serializationException.causedBy(BufferUnderflowException.class)) {
                throw new SerializationException("Buffer limit exceeded reading object of type: " + clazz.getName(), serializationException);
            }
            throw new SerializationException("Unable to deserialize object of type: " + clazz.getName(), serializationException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new SerializationException("Buffer limit exceeded reading object of type: " + clazz.getName(), bufferUnderflowException);
        }
        finally {
            --context.objectGraphLevel;
            if (context.objectGraphLevel == 0) {
                context.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            for (int i = 0; i < n; ++i) {
                if (listener != listenerArray[i]) continue;
                return;
            }
            Listener[] listenerArray2 = new Listener[n + 1];
            listenerArray2[0] = listener;
            System.arraycopy(listenerArray, 0, listenerArray2, 1, n);
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Kryo listener added: " + listener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        Object object = this.listenerLock;
        synchronized (object) {
            Listener[] listenerArray = this.listeners;
            int n = listenerArray.length;
            if (n == 0) {
                return;
            }
            Listener[] listenerArray2 = new Listener[n - 1];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if (listener == listenerArray[i]) continue;
                if (n2 == n - 1) {
                    return;
                }
                listenerArray2[n2++] = listener;
            }
            System.arraycopy(listenerArray, 0, listenerArray2, 1, n);
            this.listeners = listenerArray2;
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Kryo listener removed: " + listener.getClass().getName());
        }
    }

    public void removeRemoteEntity(int n) {
        Listener[] listenerArray = this.listeners;
        if (Log.TRACE) {
            Log.trace("kryo", "Remote ID removed: " + n);
        }
        int n2 = listenerArray.length;
        for (int i = 0; i < n2; ++i) {
            listenerArray[i].remoteEntityRemoved(n);
        }
    }

    public <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception exception) {
            Exception exception2;
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                    throw new SerializationException("Class cannot be created (non-static member class): " + clazz.getName(), exception);
                }
                throw new SerializationException("Class cannot be created (missing no-arg constructor): " + clazz.getName(), exception);
            }
            catch (Exception exception3) {
                exception2 = exception3;
            }
            throw new SerializationException("Error constructing instance of class: " + clazz.getName(), exception2);
        }
    }

    public static boolean isFinal(Class clazz) {
        if (clazz.isArray()) {
            return Modifier.isFinal(ArraySerializer.getElementClass(clazz).getModifiers());
        }
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Context getContext() {
        return contextThreadLocal.get();
    }

    static class ClassReferences {
        public HashMap<Class, Integer> classToReference = new HashMap();
        public IntHashMap referenceToClass = new IntHashMap();
        public int referenceCount = 1;

        ClassReferences() {
        }

        public void reset() {
            this.classToReference.clear();
            this.referenceToClass.clear();
            this.referenceCount = 1;
        }
    }

    public static interface Listener {
        public void remoteEntityRemoved(int var1);
    }

    public static class RegisteredClass {
        final Class type;
        final int id;
        Serializer serializer;

        RegisteredClass(Class clazz, int n, Serializer serializer) {
            this.type = clazz;
            this.id = n;
            this.serializer = serializer;
        }

        public Class getType() {
            return this.type;
        }

        public Serializer getSerializer() {
            return this.serializer;
        }

        public void setSerializer(Serializer serializer) {
            this.serializer = serializer;
        }

        public int getID() {
            return this.id;
        }
    }
}

