/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Serializer {
    private static final byte NULL_OBJECT = 0;
    private static final byte NOT_NULL_OBJECT = 1;
    private boolean canBeNull = true;

    public void setCanBeNull(boolean bl) {
        this.canBeNull = bl;
    }

    public final void writeObject(ByteBuffer byteBuffer, Object object) {
        if (this.canBeNull) {
            if (object == null) {
                if (Log.TRACE) {
                    Log.trace("kryo", "Wrote object: null");
                }
                byteBuffer.put((byte)0);
                return;
            }
            byteBuffer.put((byte)1);
        }
        this.writeObjectData(byteBuffer, object);
    }

    public abstract void writeObjectData(ByteBuffer var1, Object var2);

    public final <T> T readObject(ByteBuffer byteBuffer, Class<T> clazz) {
        if (this.canBeNull && byteBuffer.get() == 0) {
            if (Log.TRACE) {
                Log.trace("kryo", "Read object: null");
            }
            return null;
        }
        return this.readObjectData(byteBuffer, clazz);
    }

    public abstract <T> T readObjectData(ByteBuffer var1, Class<T> var2);

    public <T> T newInstance(Kryo kryo, Class<T> clazz) {
        return kryo.newInstance(clazz);
    }

    public boolean isFinal(Class clazz) {
        return Kryo.isFinal(clazz);
    }
}

