/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.Compressor;
import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class BlowfishCompressor
extends Compressor {
    private SecretKeySpec keySpec;

    public BlowfishCompressor(Serializer serializer, byte[] byArray) {
        this(serializer, byArray, 2048);
    }

    public BlowfishCompressor(Serializer serializer, byte[] byArray, int n) {
        super(serializer, n);
        this.keySpec = new SecretKeySpec(byArray, "Blowfish");
    }

    public void compress(ByteBuffer byteBuffer, Object object, ByteBuffer byteBuffer2) {
        Context context = Kryo.getContext();
        Cipher cipher = (Cipher)context.get(this, "encryptCipher");
        try {
            if (cipher == null) {
                cipher = Cipher.getInstance("Blowfish");
                cipher.init(1, this.keySpec);
                context.put(this, "encryptCipher", cipher);
            }
            cipher.doFinal(byteBuffer, byteBuffer2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SerializationException(generalSecurityException);
        }
    }

    public void decompress(ByteBuffer byteBuffer, Class clazz, ByteBuffer byteBuffer2) {
        Context context = Kryo.getContext();
        Cipher cipher = (Cipher)context.get(this, "decryptCipher");
        try {
            if (cipher == null) {
                cipher = Cipher.getInstance("Blowfish");
                cipher.init(2, this.keySpec);
                context.put(this, "decryptCipher", cipher);
            }
            cipher.doFinal(byteBuffer, byteBuffer2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SerializationException(generalSecurityException);
        }
    }
}

