/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionSerializer
extends Serializer {
    private final Kryo kryo;
    private boolean elementsCanBeNull = true;
    private Serializer serializer;
    private Class elementClass;
    private Integer length;

    public CollectionSerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setElementsCanBeNull(boolean bl) {
        this.elementsCanBeNull = bl;
    }

    public void setElementClass(Class clazz) {
        this.elementClass = clazz;
        this.serializer = clazz == null ? null : this.kryo.getRegisteredClass(clazz).getSerializer();
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setElementClass(Class clazz, Serializer serializer) {
        this.elementClass = clazz;
        this.serializer = serializer;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        int n;
        Collection collection = (Collection)object;
        if (this.length != null) {
            n = this.length;
        } else {
            n = collection.size();
            IntSerializer.put(byteBuffer, n, true);
        }
        if (n == 0) {
            return;
        }
        if (this.serializer != null) {
            if (this.elementsCanBeNull) {
                for (Object e : collection) {
                    this.serializer.writeObject(byteBuffer, e);
                }
            } else {
                for (Object e : collection) {
                    this.serializer.writeObjectData(byteBuffer, e);
                }
            }
        } else {
            for (Object e : collection) {
                this.kryo.writeClassAndObject(byteBuffer, e);
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote collection: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        int n = this.length != null ? this.length : IntSerializer.get(byteBuffer, true);
        Collection collection = clazz == ArrayList.class ? new ArrayList(n) : (Collection)this.newInstance(this.kryo, clazz);
        if (n == 0) {
            return (T)collection;
        }
        if (this.serializer != null) {
            if (this.elementsCanBeNull) {
                for (int i = 0; i < n; ++i) {
                    collection.add(this.serializer.readObject(byteBuffer, this.elementClass));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    collection.add(this.serializer.readObjectData(byteBuffer, this.elementClass));
                }
            }
        } else {
            for (int i = 0; i < n; ++i) {
                collection.add(this.kryo.readClassAndObject(byteBuffer));
            }
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read collection: " + collection);
        }
        return (T)collection;
    }
}

