/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class ShortSerializer
extends Serializer {
    private boolean optimizePositive = true;
    private static final byte SHORT = -128;
    private static final byte SHORT_POSITIVE = -1;

    public ShortSerializer() {
    }

    public ShortSerializer(Boolean bl) {
        this.optimizePositive = bl;
    }

    public Short readObjectData(ByteBuffer byteBuffer, Class clazz) {
        short s = ShortSerializer.get(byteBuffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Read short: " + s);
        }
        return s;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        ShortSerializer.put(byteBuffer, (Short)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote short: " + object);
        }
    }

    public static short put(ByteBuffer byteBuffer, short s, boolean bl) {
        if (bl) {
            if (s >= 0 && s <= 254) {
                byteBuffer.put((byte)s);
                return 1;
            }
            byteBuffer.put((byte)-1);
            byteBuffer.putShort(s);
        } else {
            if (s >= -127 && s <= 127) {
                byteBuffer.put((byte)s);
                return 1;
            }
            byteBuffer.put((byte)-128);
            byteBuffer.putShort(s);
        }
        return 3;
    }

    public static short get(ByteBuffer byteBuffer, boolean bl) {
        byte by = byteBuffer.get();
        if (bl) {
            if (by == -1) {
                return byteBuffer.getShort();
            }
            if (by < 0) {
                return (short)(by + 256);
            }
        } else if (by == -128) {
            return byteBuffer.getShort();
        }
        return by;
    }
}

