/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;

class UdpConnection {
    InetSocketAddress connectedAddress;
    DatagramChannel datagramChannel;
    int keepAliveMillis = 19000;
    final ByteBuffer readBuffer;
    final ByteBuffer writeBuffer;
    private final Kryo kryo;
    private SelectionKey selectionKey;
    private final Object writeLock = new Object();
    private long lastCommunicationTime;

    public UdpConnection(Kryo kryo, int n) {
        this.kryo = kryo;
        this.readBuffer = ByteBuffer.allocateDirect(n);
        this.writeBuffer = ByteBuffer.allocateDirect(n);
    }

    public void bind(Selector selector, int n) throws IOException {
        this.close();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(new InetSocketAddress(n));
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    public void connect(Selector selector, InetSocketAddress inetSocketAddress) throws IOException {
        this.close();
        try {
            this.datagramChannel = selector.provider().openDatagramChannel();
            this.datagramChannel.socket().bind(null);
            this.datagramChannel.socket().connect(inetSocketAddress);
            this.datagramChannel.configureBlocking(false);
            this.selectionKey = this.datagramChannel.register(selector, 1);
            this.lastCommunicationTime = System.currentTimeMillis();
            this.connectedAddress = inetSocketAddress;
        }
        catch (IOException iOException) {
            this.close();
            IOException iOException2 = new IOException("Unable to connect to: " + inetSocketAddress);
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    public InetSocketAddress readFromAddress() throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        this.lastCommunicationTime = System.currentTimeMillis();
        return (InetSocketAddress)datagramChannel.receive(this.readBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject(Connection connection) {
        this.readBuffer.flip();
        try {
            Context context = Kryo.getContext();
            context.put("connection", connection);
            if (connection != null) {
                context.setRemoteEntityID(connection.id);
            }
            Object object = this.kryo.readClassAndObject(this.readBuffer);
            if (this.readBuffer.hasRemaining()) {
                throw new SerializationException("Incorrect number of bytes (" + this.readBuffer.remaining() + " remaining) used to deserialize object: " + object);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            this.readBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Connection connection, Object object, SocketAddress socketAddress) throws IOException {
        DatagramChannel datagramChannel = this.datagramChannel;
        if (datagramChannel == null) {
            throw new SocketException("Connection is closed.");
        }
        Object object2 = this.writeLock;
        synchronized (object2) {
            int n;
            try {
                Context context = Kryo.getContext();
                context.put("connection", connection);
                context.setRemoteEntityID(connection.id);
                this.kryo.writeClassAndObject(this.writeBuffer, object);
                this.writeBuffer.flip();
                int n2 = this.writeBuffer.limit();
                datagramChannel.send(this.writeBuffer, socketAddress);
                this.lastCommunicationTime = System.currentTimeMillis();
                boolean bl = !this.writeBuffer.hasRemaining();
                n = bl ? n2 : -1;
                this.writeBuffer.clear();
            }
            catch (Throwable throwable) {
                this.writeBuffer.clear();
                throw throwable;
            }
            return n;
        }
    }

    public void close() {
        block4: {
            this.connectedAddress = null;
            try {
                if (this.datagramChannel != null) {
                    this.datagramChannel.close();
                    this.datagramChannel = null;
                    if (this.selectionKey != null) {
                        this.selectionKey.selector().wakeup();
                    }
                }
            }
            catch (IOException iOException) {
                if (!Log.DEBUG) break block4;
                Log.debug("kryonet", "Unable to close UDP connection.", iOException);
            }
        }
    }

    public boolean needsKeepAlive(long l) {
        return this.connectedAddress != null && this.keepAliveMillis > 0 && l - this.lastCommunicationTime > (long)this.keepAliveMillis;
    }
}

