/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class LongSerializer
extends Serializer {
    private boolean optimizePositive;

    public LongSerializer() {
    }

    public LongSerializer(boolean bl) {
        this.optimizePositive = bl;
    }

    public Long readObjectData(ByteBuffer byteBuffer, Class clazz) {
        long l = LongSerializer.get(byteBuffer, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Read long: " + l);
        }
        return l;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        LongSerializer.put(byteBuffer, (Long)object, this.optimizePositive);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote long: " + object);
        }
    }

    public static long put(ByteBuffer byteBuffer, long l, boolean bl) {
        if (!bl) {
            l = l << 1 ^ l >> 63;
        }
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 1L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 2L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 3L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 4L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 5L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 6L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 7L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 8L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        if (((l >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            byteBuffer.put((byte)l);
            return 9L;
        }
        byteBuffer.put((byte)((int)l & 0x7F | 0x80));
        byteBuffer.put((byte)(l >>>= 7));
        return 10L;
    }

    public static long get(ByteBuffer byteBuffer, boolean bl) {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = byteBuffer.get();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            if (!bl) {
                l = l >>> 1 ^ -(l & 1L);
            }
            return l;
        }
        throw new SerializationException("Malformed long.");
    }
}

