/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.compress.ByteArrayCompressor;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class DeflateCompressor
extends ByteArrayCompressor {
    private Deflater deflater = new Deflater();
    private Inflater inflater = new Inflater();

    public DeflateCompressor(Serializer serializer) {
        this(serializer, 2048);
    }

    public DeflateCompressor(Serializer serializer, int n) {
        super(serializer, n);
    }

    public void compress(byte[] byArray, int n, ByteBuffer byteBuffer) {
        this.deflater.reset();
        this.deflater.setInput(byArray, 0, n);
        this.deflater.finish();
        byteBuffer.position(this.deflater.deflate(byteBuffer.array()));
    }

    public void decompress(byte[] byArray, int n, ByteBuffer byteBuffer) {
        this.inflater.reset();
        this.inflater.setInput(byArray, 0, n);
        try {
            byteBuffer.position(this.inflater.inflate(byteBuffer.array()));
        }
        catch (DataFormatException dataFormatException) {
            throw new SerializationException("Error inflating data.", dataFormatException);
        }
    }
}

