/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.compress;

import com.esotericsoftware.kryo.Compressor;
import com.esotericsoftware.kryo.Context;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.compress.Delta;
import com.esotericsoftware.kryo.util.IntHashMap;
import java.nio.ByteBuffer;

public class DeltaCompressor
extends Compressor {
    private final Kryo kryo;
    private final int chunkSize;
    final IntHashMap<ByteBuffer> contextToRemoteData = new IntHashMap();
    final IntHashMap<ByteBuffer> contextToLocalData = new IntHashMap();
    private Kryo.Listener removeBuffersListener = new Kryo.Listener(){

        public void remoteEntityRemoved(int n) {
            DeltaCompressor.this.contextToRemoteData.remove(n);
            DeltaCompressor.this.contextToLocalData.remove(n);
        }
    };

    public DeltaCompressor(Kryo kryo, Serializer serializer) {
        this(kryo, serializer, 2048, 8);
    }

    public DeltaCompressor(Kryo kryo, Serializer serializer, int n, int n2) {
        super(serializer, n);
        this.kryo = kryo;
        this.chunkSize = n2;
    }

    public void compress(ByteBuffer byteBuffer, Object object, ByteBuffer byteBuffer2) {
        int n = byteBuffer.position();
        Context context = Kryo.getContext();
        int n2 = context.getRemoteEntityID();
        ByteBuffer byteBuffer3 = this.contextToRemoteData.get(n2);
        Delta delta = (Delta)context.get(this, "delta");
        if (delta == null) {
            delta = new Delta(this.bufferSize, this.chunkSize);
            context.put(this, "delta", delta);
        }
        delta.compress(byteBuffer3, byteBuffer, byteBuffer2);
        if (byteBuffer3 == null) {
            byteBuffer3 = ByteBuffer.allocate(this.bufferSize);
            this.contextToRemoteData.put(n2, byteBuffer3);
            this.kryo.addListener(this.removeBuffersListener);
        }
        byteBuffer3.clear();
        byteBuffer.position(n);
        byteBuffer3.put(byteBuffer);
        byteBuffer3.flip();
    }

    public void decompress(ByteBuffer byteBuffer, Class clazz, ByteBuffer byteBuffer2) {
        Context context = Kryo.getContext();
        int n = context.getRemoteEntityID();
        ByteBuffer byteBuffer3 = this.contextToLocalData.get(n);
        Delta delta = (Delta)context.get(this, "delta");
        if (delta == null) {
            delta = new Delta(this.bufferSize, this.chunkSize);
            context.put(this, "delta", delta);
        }
        delta.decompress(byteBuffer3, byteBuffer, byteBuffer2);
        if (byteBuffer3 == null) {
            byteBuffer3 = ByteBuffer.allocate(this.bufferSize);
            this.contextToLocalData.put(n, byteBuffer3);
            this.kryo.addListener(this.removeBuffersListener);
        }
        byteBuffer3.clear();
        byteBuffer2.flip();
        byteBuffer3.put(byteBuffer2);
        byteBuffer3.flip();
    }
}

