/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.BigIntegerSerializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class BigDecimalSerializer
extends Serializer {
    private BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

    public BigDecimal readObjectData(ByteBuffer byteBuffer, Class clazz) {
        BigInteger bigInteger = (BigInteger)this.bigIntegerSerializer.readObjectData(byteBuffer, (Class)null);
        int n = IntSerializer.get(byteBuffer, false);
        BigDecimal bigDecimal = new BigDecimal(bigInteger, n);
        if (Log.TRACE) {
            Log.trace("kryo", "Read BigDecimal: " + bigDecimal);
        }
        return bigDecimal;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        BigDecimal bigDecimal = (BigDecimal)object;
        this.bigIntegerSerializer.writeObjectData(byteBuffer, bigDecimal.unscaledValue());
        IntSerializer.put(byteBuffer, bigDecimal.scale(), false);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote BigDecimal: " + bigDecimal);
        }
    }
}

