/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumSerializer
extends Serializer {
    private Object[] enumConstants;

    public EnumSerializer(Class<? extends Enum> clazz) {
        this.enumConstants = clazz.getEnumConstants();
        if (this.enumConstants == null) {
            throw new IllegalArgumentException("The type must be an enum: " + clazz);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        int n = IntSerializer.get(byteBuffer, true);
        if (n < 0 || n > this.enumConstants.length - 1) {
            throw new SerializationException("Invalid ordinal for enum \"" + clazz.getName() + "\": " + n);
        }
        Object object = this.enumConstants[n];
        if (Log.TRACE) {
            Log.trace("kryo", "Read enum: " + object);
        }
        return (T)object;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        EnumSerializer.put(byteBuffer, (Enum)object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote enum: " + object);
        }
    }

    public static void put(ByteBuffer byteBuffer, Enum enum_) {
        IntSerializer.put(byteBuffer, enum_.ordinal(), true);
    }

    public static <T> T get(ByteBuffer byteBuffer, Class<T> clazz) {
        T[] TArray = clazz.getEnumConstants();
        if (TArray == null) {
            throw new SerializationException("Class is not an enum: " + clazz.getName());
        }
        int n = IntSerializer.get(byteBuffer, true);
        if (n < 0 || n > TArray.length - 1) {
            throw new SerializationException("Invalid ordinal for enum \"" + clazz.getName() + "\": " + n);
        }
        return TArray[n];
    }
}

