/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapSerializer
extends Serializer {
    private final Kryo kryo;
    private Class keyClass;
    private Class valueClass;
    private Serializer keySerializer;
    private Serializer valueSerializer;
    private boolean keysCanBeNull = true;
    private boolean valuesCanBeNull = true;

    public MapSerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void setKeysCanBeNull(boolean bl) {
        this.keysCanBeNull = bl;
    }

    public void setKeyClass(Class clazz) {
        this.keyClass = clazz;
        this.keySerializer = clazz == null ? null : this.kryo.getRegisteredClass(clazz).getSerializer();
    }

    public void setKeyClass(Class clazz, Serializer serializer) {
        this.keyClass = clazz;
        this.keySerializer = serializer;
    }

    public void setValueClass(Class clazz) {
        this.valueClass = clazz;
        this.valueSerializer = clazz == null ? null : this.kryo.getRegisteredClass(clazz).getSerializer();
    }

    public void setValueClass(Class clazz, Serializer serializer) {
        this.valueClass = clazz;
        this.valueSerializer = serializer;
    }

    public void setValuesCanBeNull(boolean bl) {
        this.valuesCanBeNull = bl;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        Map map = (Map)object;
        int n = map.size();
        IntSerializer.put(byteBuffer, n, true);
        if (n == 0) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (this.keySerializer != null) {
                if (this.keysCanBeNull) {
                    this.keySerializer.writeObject(byteBuffer, entry.getKey());
                } else {
                    this.keySerializer.writeObjectData(byteBuffer, entry.getKey());
                }
            } else {
                this.kryo.writeClassAndObject(byteBuffer, entry.getKey());
            }
            if (this.valueSerializer != null) {
                if (this.valuesCanBeNull) {
                    this.valueSerializer.writeObject(byteBuffer, entry.getValue());
                    continue;
                }
                this.valueSerializer.writeObjectData(byteBuffer, entry.getValue());
                continue;
            }
            this.kryo.writeClassAndObject(byteBuffer, entry.getValue());
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote map: " + object);
        }
    }

    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        Map map = (Map)this.newInstance(this.kryo, clazz);
        int n = IntSerializer.get(byteBuffer, true);
        if (n == 0) {
            return (T)map;
        }
        for (int i = 0; i < n; ++i) {
            Object object = this.keySerializer != null ? (this.keysCanBeNull ? this.keySerializer.readObject(byteBuffer, this.keyClass) : this.keySerializer.readObjectData(byteBuffer, this.keyClass)) : this.kryo.readClassAndObject(byteBuffer);
            Object object2 = this.valueSerializer != null ? (this.valuesCanBeNull ? this.valueSerializer.readObject(byteBuffer, this.valueClass) : this.valueSerializer.readObjectData(byteBuffer, this.valueClass)) : this.kryo.readClassAndObject(byteBuffer);
            map.put(object, object2);
        }
        if (Log.TRACE) {
            Log.trace("kryo", "Read map: " + map);
        }
        return (T)map;
    }
}

