/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.SerializationException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableSerializer
extends Serializer {
    @Override
    public <T> T readObjectData(ByteBuffer byteBuffer, Class<T> clazz) {
        T t = SerializableSerializer.get(byteBuffer, clazz);
        if (Log.TRACE) {
            Log.trace("kryo", "Read object: " + t);
        }
        return t;
    }

    @Override
    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        SerializableSerializer.put(byteBuffer, object);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote object: " + object);
        }
    }

    public static void put(ByteBuffer byteBuffer, Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            IntSerializer.put(byteBuffer, byArray.length, true);
            byteBuffer.put(byArray);
        }
        catch (BufferOverflowException bufferOverflowException) {
            throw bufferOverflowException;
        }
        catch (Exception exception) {
            throw new SerializationException("Error during Java serialization.", exception);
        }
    }

    public static <T> T get(ByteBuffer byteBuffer, Class<T> clazz) {
        int n = IntSerializer.get(byteBuffer, true);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        try {
            return (T)new ObjectInputStream(new ByteArrayInputStream(byArray)).readObject();
        }
        catch (Exception exception) {
            throw new SerializationException("Error during Java deserialization.", exception);
        }
    }
}

