/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.serialize.IntSerializer;
import com.esotericsoftware.minlog.Log;
import java.nio.ByteBuffer;

public class StringSerializer
extends Serializer {
    public String readObjectData(ByteBuffer byteBuffer, Class clazz) {
        String string = StringSerializer.get(byteBuffer);
        if (Log.TRACE) {
            Log.trace("kryo", "Read string: " + string);
        }
        return string;
    }

    public void writeObjectData(ByteBuffer byteBuffer, Object object) {
        String string = (String)object;
        StringSerializer.put(byteBuffer, string);
        if (Log.TRACE) {
            Log.trace("kryo", "Wrote string: " + object);
        }
    }

    public static void put(ByteBuffer byteBuffer, String string) {
        int n = string.length();
        IntSerializer.put(byteBuffer, n, true);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c <= '\u007f') {
                byteBuffer.put((byte)c);
                continue;
            }
            if (c > '\u07ff') {
                byteBuffer.put((byte)(0xE0 | c >> 12 & 0xF));
                byteBuffer.put((byte)(0x80 | c >> 6 & 0x3F));
                byteBuffer.put((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            byteBuffer.put((byte)(0xC0 | c >> 6 & 0x1F));
            byteBuffer.put((byte)(0x80 | c >> 0 & 0x3F));
        }
    }

    public static String get(ByteBuffer byteBuffer) {
        int n = IntSerializer.get(byteBuffer, true);
        char[] cArray = Kryo.getContext().getCharArray(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byteBuffer.get() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n2++] = (char)n3;
                    break;
                }
                case 12: 
                case 13: {
                    cArray[n2++] = (char)((n3 & 0x1F) << 6 | byteBuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    cArray[n2++] = (char)((n3 & 0xF) << 12 | (byteBuffer.get() & 0x3F) << 6 | (byteBuffer.get() & 0x3F) << 0);
                }
            }
        }
        return new String(cArray, 0, n);
    }
}

