/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.plain.logging;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.event.Logging;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.event.LoggingBus;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.ibm.plain.bootstrap.BaseComponent;
import com.ibm.plain.logging.package$;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0002\"-\u0011q\u0001T8hO&twM\u0003\u0002\u0004\t\u00059An\\4hS:<'BA\u0003\u0007\u0003\u0015\u0001H.Y5o\u0015\t9\u0001\"A\u0002jE6T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u00012!\u0004\t\u0013\u001b\u0005q!BA\b\u0005\u0003%\u0011wn\u001c;tiJ\f\u0007/\u0003\u0002\u0012\u001d\ti!)Y:f\u0007>l\u0007o\u001c8f]R\u0004\"a\u0005\u0001\u000e\u0003\tAQ!\u0006\u0001\u0005\u0002Y\ta\u0001P5oSRtD#\u0001\n\t\u000ba\u0001A\u0011I\r\u0002\u0013%\u001c8\u000b^8qa\u0016$W#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u0005\u0001C!E\u0005)1\u000f^1siV\t!\u0003C\u0003%\u0001\u0011\u0005#%\u0001\u0003ti>\u0004\b\"\u0002\u0014\u0001\t\u0003:\u0013\u0001E1xC&$H+\u001a:nS:\fG/[8o)\tA3\u0006\u0005\u0002\u001cS%\u0011!\u0006\b\u0002\u0005+:LG\u000fC\u0003-K\u0001\u0007Q&A\u0004uS6,w.\u001e;\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005Ib\u0012AC2p]\u000e,(O]3oi&\u0011Ag\f\u0002\t\tV\u0014\u0018\r^5p]\")a\u0007\u0001C\u0001o\u0005I\u0011N\u001c4p\u0019\u00164X\r\\\u000b\u0002Q!)\u0011\b\u0001C\u0001u\u0005a1M]3bi\u0016dunZ4feR\u00111h\u0011\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nQ!\u001a<f]RT\u0011\u0001Q\u0001\u0005C.\\\u0017-\u0003\u0002C{\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\b\"\u0002#9\u0001\u0004)\u0015aA1osB\u00111DR\u0005\u0003\u000fr\u00111!\u00118z\u0011\u0015I\u0004\u0001\"\u0001J)\tY$\nC\u0003L\u0011\u0002\u0007A*\u0001\u0003oC6,\u0007CA'Q\u001d\tYb*\u0003\u0002P9\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyE\u0004C\u0003U\u0001\u0011\u0005Q+A\u0006hKRdun\u001a'fm\u0016dW#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002R1\")a\f\u0001C\u0001?\u0006Y1/\u001a;M_\u001edUM^3m)\tA\u0003\rC\u0003b;\u0002\u0007A*A\u0003mKZ,G\u000e\u0003\u0005d\u0001!\u0015\r\u0015\"\u0003e\u00035awnZ4j]\u001e\u001c\u0016p\u001d;f[V\tQ\r\u0005\u0002gS6\tqM\u0003\u0002i\u007f\u0005)\u0011m\u0019;pe&\u0011!n\u001a\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u0005m\u0001!\u0005\t\u0015)\u0003f\u00039awnZ4j]\u001e\u001c\u0016p\u001d;f[\u0002J#\u0001\u00018\u0007\u000b\u0005\u0011\u0001\u0012A8\u0014\u00059\u0014\u0002\"B\u000bo\t\u0003\tH#\u0001:\u0011\u0005Mqw!\u0002;\u0003\u0011\u0003\u0011\u0018a\u0002'pO\u001eLgn\u001a")
public abstract class Logging
extends BaseComponent<Logging> {
    private ActorSystem loggingSystem;
    private volatile boolean bitmap$0;

    /*
     * WARNING - void declaration
     */
    private ActorSystem loggingSystem$lzycompute() {
        Logging logging = this;
        synchronized (logging) {
            if (!this.bitmap$0) {
                void var2_2;
                Option option;
                ActorSystem system = ActorSystem$.MODULE$.apply(this.name());
                system.eventStream().setLogLevel(((Logging.LogLevel)(!(option = Logging$.MODULE$.levelFor(package$.MODULE$.loggingLevel())).isEmpty() ? option.get() : new Logging.LogLevel(Logging$.MODULE$.DebugLevel()))).asInt());
                this.loggingSystem = var2_2;
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.loggingSystem;
        }
    }

    @Override
    public boolean isStopped() {
        return this.loggingSystem().isTerminated();
    }

    @Override
    public Logging start() {
        if (this.isEnabled()) {
            if (this.isStopped()) {
                throw new IllegalStateException("Underlying system already terminated and cannot be started more than once.");
            }
            LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)context);
                context.reset();
                configurator.doConfigure(this.getClass().getClassLoader().getResourceAsStream("logback.xml"));
                if (package$.MODULE$.loggingConsole().enable() && package$.MODULE$.loggingConsole().toFile()) {
                    try {
                        Path path = Paths.get(System.getProperty("plain.logging.console.file"), new String[0]);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        PrintStream console = new PrintStream(new FileOutputStream(path.toFile()));
                        System.setOut(console);
                        System.setErr(console);
                    }
                    catch (Throwable throwable) {
                        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Could not create plain.logging.console.file : ").append((Object)throwable).toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Predef$.MODULE$.println((Object)throwable);
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
            if (com.ibm.plain.config.package$.MODULE$.logConfigOnStart() && package$.MODULE$.defaultLogger().isInfoEnabled()) {
                package$.MODULE$.defaultLogger().info(com.ibm.plain.config.package$.MODULE$.settings().root().render());
            }
        }
        return this;
    }

    @Override
    public Logging stop() {
        if (this.isStarted()) {
            this.loggingSystem().shutdown();
        }
        return this;
    }

    @Override
    public void awaitTermination(Duration timeout) {
        if (!this.loggingSystem().isTerminated()) {
            this.loggingSystem().awaitTermination(timeout);
        }
    }

    public void infoLevel() {
        this.loggingSystem().eventStream().setLogLevel(Logging$.MODULE$.InfoLevel());
    }

    public LoggingAdapter createLogger(Object any) {
        return Logging$.MODULE$.getLogger((LoggingBus)this.loggingSystem().eventStream(), any.getClass());
    }

    public LoggingAdapter createLogger(String name) {
        return Logging$.MODULE$.getLogger((LoggingBus)this.loggingSystem().eventStream(), (Object)name);
    }

    public String getLogLevel() {
        int n = this.loggingSystem().eventStream().logLevel();
        String string = Logging$.MODULE$.DebugLevel() == n ? "Debug" : (Logging$.MODULE$.InfoLevel() == n ? "Info" : (Logging$.MODULE$.WarningLevel() == n ? "Warning" : (Logging$.MODULE$.ErrorLevel() == n ? "Error" : Logging.LogLevel$.MODULE$.toString$extension(n))));
        return string;
    }

    public void setLogLevel(String level) {
        int n = !("Debug" != null ? !"Debug".equals(level) : level != null) ? Logging$.MODULE$.DebugLevel() : (!("Info" != null ? !"Info".equals(level) : level != null) ? Logging$.MODULE$.InfoLevel() : (!("Warning" != null ? !"Warning".equals(level) : level != null) ? Logging$.MODULE$.WarningLevel() : (!("Error" != null ? !"Error".equals(level) : level != null) ? Logging$.MODULE$.ErrorLevel() : this.loggingSystem().eventStream().logLevel())));
        this.loggingSystem().eventStream().setLogLevel(n);
    }

    private ActorSystem loggingSystem() {
        return this.bitmap$0 ? this.loggingSystem : this.loggingSystem$lzycompute();
    }

    public Logging() {
        super("plain-logging");
    }
}

