/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.plain.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class Base64OutputStream
extends FilterOutputStream {
    private final byte[] buffer = new byte[3];
    private int bufsize = 0;
    private byte[] outbuf;
    private int count = 0;
    private final int bytesPerLine;
    private final int lineLimit;
    private boolean noCRLF = false;
    private static byte[] newline = new byte[]{13, 10};
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64OutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        if (n == Integer.MAX_VALUE || n < 4) {
            this.noCRLF = true;
            n = 76;
        }
        this.bytesPerLine = n = n / 4 * 4;
        this.lineLimit = n / 4 * 3;
        if (this.noCRLF) {
            this.outbuf = new byte[n];
        } else {
            this.outbuf = new byte[n + 2];
            this.outbuf[n] = 13;
            this.outbuf[n + 1] = 10;
        }
    }

    public Base64OutputStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n + n2;
        while (this.bufsize != 0 && n < n4) {
            this.write(byArray[n++]);
        }
        int n5 = (this.bytesPerLine - this.count) / 4 * 3;
        if (n + n5 < n4) {
            n3 = Base64OutputStream.encodedSize(n5);
            if (!this.noCRLF) {
                this.outbuf[n3++] = 13;
                this.outbuf[n3++] = 10;
            }
            this.out.write(Base64OutputStream.encode(byArray, n, n5, this.outbuf), 0, n3);
            n += n5;
            this.count = 0;
        }
        while (n + this.lineLimit < n4) {
            this.out.write(Base64OutputStream.encode(byArray, n, this.lineLimit, this.outbuf));
            n += this.lineLimit;
        }
        if (n + 3 < n4) {
            n5 = n4 - n;
            n5 = n5 / 3 * 3;
            n3 = Base64OutputStream.encodedSize(n5);
            this.out.write(Base64OutputStream.encode(byArray, n, n5, this.outbuf), 0, n3);
            n += n5;
            this.count += n3;
        }
        while (n < n4) {
            this.write(byArray[n]);
            ++n;
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(int n) throws IOException {
        this.buffer[this.bufsize++] = (byte)n;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.count > 0 && !this.noCRLF) {
            this.out.write(newline);
            this.out.flush();
        }
        this.out.close();
    }

    private void encode() throws IOException {
        int n = Base64OutputStream.encodedSize(this.bufsize);
        this.out.write(Base64OutputStream.encode(this.buffer, 0, this.bufsize, this.outbuf), 0, n);
        this.count += n;
        if (this.count >= this.bytesPerLine) {
            if (!this.noCRLF) {
                this.out.write(newline);
            }
            this.count = 0;
        }
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        return Base64OutputStream.encode(byArray, 0, byArray.length, null);
    }

    private static byte[] encode(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3;
        if (byArray2 == null) {
            byArray2 = new byte[Base64OutputStream.encodedSize(n2)];
        }
        int n4 = n;
        int n5 = 0;
        while (n2 >= 3) {
            n3 = byArray[n4++] & 0xFF;
            n3 <<= 8;
            n3 |= byArray[n4++] & 0xFF;
            n3 <<= 8;
            byArray2[n5 + 3] = (byte)pem_array[(n3 |= byArray[n4++] & 0xFF) & 0x3F];
            byArray2[n5 + 2] = (byte)pem_array[(n3 >>= 6) & 0x3F];
            byArray2[n5 + 1] = (byte)pem_array[(n3 >>= 6) & 0x3F];
            byArray2[n5 + 0] = (byte)pem_array[(n3 >>= 6) & 0x3F];
            n2 -= 3;
            n5 += 4;
        }
        if (n2 == 1) {
            n3 = byArray[n4++] & 0xFF;
            byArray2[n5 + 3] = 61;
            byArray2[n5 + 2] = 61;
            byArray2[n5 + 1] = (byte)pem_array[(n3 <<= 4) & 0x3F];
            byArray2[n5 + 0] = (byte)pem_array[(n3 >>= 6) & 0x3F];
        } else if (n2 == 2) {
            n3 = byArray[n4++] & 0xFF;
            n3 <<= 8;
            n3 |= byArray[n4++] & 0xFF;
            byArray2[n5 + 3] = 61;
            byArray2[n5 + 2] = (byte)pem_array[(n3 <<= 2) & 0x3F];
            byArray2[n5 + 1] = (byte)pem_array[(n3 >>= 6) & 0x3F];
            byArray2[n5 + 0] = (byte)pem_array[(n3 >>= 6) & 0x3F];
        }
        return byArray2;
    }

    private static int encodedSize(int n) {
        return (n + 2) / 3 * 4;
    }
}

