/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.audit;

import com.techempower.audit.AuditSession;
import com.techempower.audit.Auditable;
import com.techempower.helper.NumberHelper;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Audit {
    public static final int NONE = 0;
    public static final int ADDITION = 1;
    public static final int CHANGE = 2;
    public static final int DELETION = 3;
    private static final String[] TYPE_NAMES = new String[]{"None", "Addition", "Change", "Deletion"};
    public static final int AUDIT_ID_NOT_SET = 0;
    private int auditID = 0;
    private int type;
    private Date timestamp;
    private Auditable affected;
    private int attributeID;
    private String originalValue;
    private String newValue;
    private Map<String, String> customAttributes;
    private AuditSession session;

    public Audit(AuditSession session, int type, Auditable affected, int attributeID, String originalValue, String newValue) {
        this.type = NumberHelper.boundInteger(type, 0, TYPE_NAMES.length - 1);
        this.session = session;
        this.affected = affected;
        this.attributeID = attributeID;
        this.timestamp = new Date();
        this.setOriginalValue(originalValue);
        this.setNewValue(newValue);
    }

    public AuditSession getSession() {
        return this.session;
    }

    public void setSession(AuditSession session) {
        this.session = session;
    }

    public String getAuditTypeName() {
        return Audit.getAuditTypeName(this.getType());
    }

    public static String getAuditTypeName(int type) {
        if (type >= 0 && type < TYPE_NAMES.length) {
            return TYPE_NAMES[type];
        }
        return TYPE_NAMES[0];
    }

    public int getAuditID() {
        return this.auditID;
    }

    public void setAuditID(int auditID) {
        this.auditID = auditID;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = NumberHelper.boundInteger(type, 0, TYPE_NAMES.length - 1);
    }

    public Auditable getAffected() {
        return this.affected;
    }

    public void setAffected(Auditable affected) {
        this.affected = affected;
    }

    public int getAttributeID() {
        return this.attributeID;
    }

    public void setAttributeID(int attributeID) {
        this.attributeID = attributeID;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String value) {
        int maxLength = this.session.getManager().getMaximumValueLength();
        this.newValue = value != null && value.length() > maxLength ? value.substring(0, maxLength) : value;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String value) {
        int maxLength = this.session.getManager().getMaximumValueLength();
        this.originalValue = value != null && value.length() > maxLength ? value.substring(0, maxLength) : value;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void addCustom(String name, String value) {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, String>();
        }
        int maxLength = this.session.getManager().getMaximumValueLength();
        if (value.length() > maxLength) {
            this.customAttributes.put(name, value.substring(0, maxLength));
        } else {
            this.customAttributes.put(name, value);
        }
    }

    public boolean hasCustom() {
        return this.customAttributes != null && this.customAttributes.size() > 0;
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public void removeCustom(String name) {
        if (this.customAttributes != null) {
            this.customAttributes.remove(name);
        }
    }
}

