/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.audit;

import com.techempower.audit.Audit;
import com.techempower.audit.AuditManager;
import com.techempower.audit.Auditable;
import com.techempower.helper.CollectionHelper;
import com.techempower.helper.DateHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AuditSession {
    public static final int INITIAL_CAPACITY = 4;
    private final AuditManager manager;
    private List<Audit> audits;
    private Auditable cause;

    protected AuditSession(AuditManager manager, Auditable cause) {
        this.manager = manager;
        this.cause = cause;
    }

    public void add(int type, Auditable affected, int attributeID, String originalValue, String newValue) {
        if (affected.isInitialized() && !Objects.equals(originalValue, newValue)) {
            Audit audit = new Audit(this, type, affected, attributeID, originalValue, newValue);
            this.add(audit);
        }
    }

    public void add(int type, Auditable affected, int attributeID, Date originalValue, Date newValue) {
        if (affected.isInitialized() && !Objects.equals(originalValue, newValue)) {
            Audit audit = new Audit(this, type, affected, attributeID, originalValue == null ? null : DateHelper.STANDARD_SQL_FORMAT.format(originalValue), newValue == null ? null : DateHelper.STANDARD_SQL_FORMAT.format(newValue));
            this.add(audit);
        }
    }

    public void add(int type, Auditable affected, int attributeID, Object originalValue, Object newValue) {
        if (affected.isInitialized() && !Objects.equals(originalValue, newValue)) {
            Audit audit = new Audit(this, type, affected, attributeID, originalValue == null ? null : originalValue.toString(), newValue == null ? null : newValue.toString());
            this.add(audit);
        }
    }

    public void add(int type, Auditable affected, int attributeID, int originalValue, int newValue) {
        if (affected.isInitialized() && originalValue != newValue) {
            Audit audit = new Audit(this, type, affected, attributeID, "" + originalValue, "" + newValue);
            this.add(audit);
        }
    }

    public void add(int type, Auditable affected, int attributeID, float originalValue, float newValue) {
        if (affected.isInitialized() && originalValue != newValue) {
            Audit audit = new Audit(this, type, affected, attributeID, "" + originalValue, "" + newValue);
            this.add(audit);
        }
    }

    public void add(int type, Auditable affected, int attributeID, boolean originalValue, boolean newValue) {
        if (affected.isInitialized() && originalValue != newValue) {
            Audit audit = new Audit(this, type, affected, attributeID, originalValue ? "True" : "False", newValue ? "True" : "False");
            this.add(audit);
        }
    }

    public void add(Audit audit) {
        if (this.audits == null) {
            this.audits = new ArrayList<Audit>(4);
        }
        this.audits.add(audit);
    }

    public Audit get(int index) {
        if (this.audits != null && index >= 0 && this.audits.size() >= index) {
            return this.audits.get(index);
        }
        return null;
    }

    public int size() {
        if (this.audits != null) {
            return this.audits.size();
        }
        return 0;
    }

    public void clear() {
        if (this.audits != null) {
            this.audits.clear();
        }
    }

    public void commit() {
        if (CollectionHelper.isNonEmpty(this.audits)) {
            this.manager.commitSession(this);
            this.clear();
        }
    }

    public AuditManager getManager() {
        return this.manager;
    }

    public Auditable getCause() {
        return this.cause;
    }

    public void setCause(Auditable cause) {
        this.cause = cause;
    }

    public String toString() {
        return "AuditSession [" + this.hashCode() + "; " + this.size() + " audits]";
    }
}

