/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.audit;

import com.techempower.TechEmpowerApplication;
import com.techempower.audit.Audit;
import com.techempower.audit.AuditListener;
import com.techempower.audit.AuditSession;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseConnector;
import com.techempower.helper.DatabaseHelper;
import com.techempower.log.ComponentLog;
import com.techempower.util.StringList;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;

public class BasicDatabaseAuditListener
implements AuditListener {
    public static final String COMPONENT_CODE = "audb";
    private final ConnectorFactory connFactory;
    private final ComponentLog log;
    private String auditTable = "Audit";

    public BasicDatabaseAuditListener(TechEmpowerApplication application, ConnectorFactory connectorFactory) {
        this.connFactory = connectorFactory;
        this.log = application.getLog(COMPONENT_CODE);
    }

    public String getAuditTable() {
        return this.auditTable;
    }

    public void setAuditTable(String auditTable) {
        this.auditTable = auditTable;
    }

    @Override
    public void auditSessionCommitted(AuditSession session) {
    }

    @Override
    public void auditCommitted(AuditSession session, Audit audit) {
        if (audit.getAffected() == null || session.getCause() == null) {
            this.log.log("Unexpected input to auditCommited.  Session: " + session + ", " + "Audit: " + audit + ", " + "Affected: " + audit.getAffected() + ", " + "Cause: " + session.getCause() + ".", 10);
            return;
        }
        StringList fields = new StringList();
        StringList values = new StringList();
        Timestamp time = new Timestamp(audit.getTimestamp().getTime());
        fields.add("Type,AuditTime,Affected,AffectedTypeID,Cause,CauseTypeID,AttributeID,OriginalValue,NewValue");
        values.add("" + audit.getType());
        values.add("'" + time.toString() + "'");
        values.add("" + audit.getAffected().getId());
        values.add("" + audit.getAffected().getAuditableTypeID());
        values.add("" + session.getCause().getId());
        values.add("" + session.getCause().getAuditableTypeID());
        values.add("" + audit.getAttributeID());
        values.add(audit.getOriginalValue() == null ? "NULL" : DatabaseHelper.prepare(audit.getOriginalValue()));
        values.add(audit.getNewValue() == null ? "NULL" : DatabaseHelper.prepare(audit.getNewValue()));
        if (audit.hasCustom()) {
            Map<String, String> customAttributes = audit.getCustomAttributes();
            for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
                fields.add(entry.getKey());
                values.add(DatabaseHelper.prepare(entry.getValue()));
            }
        }
        String query = "INSERT INTO " + this.auditTable + " (" + fields + ") VALUES (" + values + ");";
        Throwable throwable = null;
        Iterator<Map.Entry<String, String>> iterator = null;
        try (DatabaseConnector dbConn = this.connFactory.getConnector();){
            dbConn.setQuery(query);
            dbConn.runUpdateQuery();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void auditSessionCommitComplete(AuditSession session) {
    }

    @Override
    public void auditsCleared(AuditSession session) {
    }

    @Override
    public String getAuditListenerName() {
        return "Basic Database Audit Listener";
    }
}

