/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.cache.EntityStore;
import com.techempower.data.EntityGroup;
import com.techempower.data.EntityMaker;
import com.techempower.helper.CollectionHelper;
import com.techempower.util.Identifiable;
import com.techempower.util.Initializable;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class CacheGroup<T extends Identifiable>
extends EntityGroup<T>
implements Initializable {
    private ConcurrentHashMap<Integer, T> objects = new ConcurrentHashMap();
    private List<T> objectsInOrder = new CopyOnWriteArrayList<T>();
    private volatile boolean initialized = false;
    private boolean errorOnInitialize = false;
    private int lowestIdentity = Integer.MAX_VALUE;
    private int highestIdentity = 0;

    protected CacheGroup(EntityStore controller, Class<T> type, String table, String id, EntityMaker<T> maker, Comparator<? super T> comparator, String where, String[] whereArguments) {
        super(controller, type, table, id, maker, comparator, where, whereArguments);
    }

    public static <T extends Identifiable> Builder<T> of(Class<T> type) {
        return new Builder<T>(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjects(Collection<T> objects) {
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            if (objects == null) {
                this.objects = new ConcurrentHashMap();
                this.objectsInOrder = new CopyOnWriteArrayList<T>();
            } else {
                ConcurrentHashMap<Integer, Identifiable> workMap = new ConcurrentHashMap<Integer, Identifiable>(objects.size());
                ArrayList<Identifiable> workList = new ArrayList<Identifiable>(objects.size());
                Identifiable co2 = null;
                for (Identifiable co2 : objects) {
                    workMap.put(co2.getId(), co2);
                    workList.add(co2);
                }
                this.objects = workMap;
                this.objectsInOrder = new CopyOnWriteArrayList<T>(workList);
                this.setInitialized(true);
            }
            this.calculateHighLowIdentitiesRecalc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            this.setInitialized(false);
            this.objects = new ConcurrentHashMap();
            this.objectsInOrder = new CopyOnWriteArrayList<T>();
            this.setErrorOnInitialize(false);
            this.resetHighLowIdentities();
        }
    }

    @Override
    public T get(int id) {
        this.initializeIfNecessary();
        return (T)((Identifiable)this.objects.get(id));
    }

    protected T getRaw(int id) {
        return (T)((Identifiable)this.objects.get(id));
    }

    public Identifiable[] select(int[] identities) {
        Identifiable[] toReturn = new Identifiable[identities.length];
        this.initializeIfNecessary();
        int i = 0;
        while (i < identities.length) {
            toReturn[i] = (Identifiable)this.objects.get(identities[i]);
            ++i;
        }
        return toReturn;
    }

    @Override
    public List<T> list() {
        this.initializeIfNecessary();
        return new ArrayList<T>(this.objectsInOrder);
    }

    @Override
    public TIntObjectMap<T> map() {
        this.initializeIfNecessary();
        ConcurrentHashMap<Integer, T> map = this.objects;
        TIntObjectHashMap toReturn = new TIntObjectHashMap(map.size());
        for (Identifiable object : map.values()) {
            toReturn.put(object.getId(), (Object)object);
        }
        return toReturn;
    }

    @Override
    public void put(T object) {
        this.initializeIfNecessary();
        boolean persisted = this.isPersisted((Identifiable)object);
        this.putPersistent(object);
        if (persisted) {
            this.reorder(object.getId());
        } else {
            this.addToCache(new Identifiable[]{object});
        }
    }

    protected void putPersistent(T object) {
        super.put(object);
    }

    @Override
    public void putAll(Collection<T> objectsToPut) {
        this.initializeIfNecessary();
        ArrayList<Integer> persisted = new ArrayList<Integer>(objectsToPut.size());
        ArrayList<Identifiable> nonPersisted = new ArrayList<Identifiable>(objectsToPut.size());
        for (Identifiable object : objectsToPut) {
            if (this.isPersisted(object)) {
                persisted.add(object.getId());
                continue;
            }
            nonPersisted.add(object);
        }
        this.putAllPersistent(objectsToPut);
        this.reorder(CollectionHelper.toIntArray(persisted));
        this.addToCache(nonPersisted.toArray((Identifiable[])Array.newInstance(this.type(), nonPersisted.size())));
    }

    protected void putAllPersistent(Collection<T> objectsToPut) {
        super.putAll(objectsToPut);
    }

    @Override
    public void remove(int id) {
        this.initializeIfNecessary();
        this.removePersistent(id);
        this.removeFromCache(id);
    }

    protected void removePersistent(int id) {
        super.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void addToCache(T ... objectsToAdd) {
        ConcurrentHashMap<Integer, T> map = this.objects;
        List<T> orderedList = this.objectsInOrder;
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            T[] TArray = objectsToAdd;
            int n = objectsToAdd.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                if (!map.containsValue(object)) {
                    if (map.containsKey(object.getId())) {
                        orderedList.remove(map.get(object.getId()));
                    }
                    map.put(object.getId(), object);
                    int search = Collections.binarySearch(orderedList, object, this.comparator());
                    if (search < 0) {
                        orderedList.add(-search - 1, object);
                    } else {
                        orderedList.add(object);
                    }
                    if (this.areHighLowIdentitiesInitialized()) {
                        if (object.getId() < this.lowestIdentity) {
                            this.lowestIdentity = object.getId();
                        }
                        if (object.getId() > this.highestIdentity) {
                            this.highestIdentity = object.getId();
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public boolean removeFromCache(T object) {
        return this.removeFromCache(object.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFromCache(int ... ids) {
        ConcurrentHashMap<Integer, T> map = this.objects;
        List<T> orderedList = this.objectsInOrder;
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                orderedList.remove(map.remove(id));
                ++n2;
            }
            this.calculateHighLowIdentitiesRecalc();
            return true;
        }
    }

    public boolean contains(T object) {
        this.initializeIfNecessary();
        return this.objects.containsValue(object);
    }

    public boolean contains(int id) {
        this.initializeIfNecessary();
        return this.objects.containsKey(id);
    }

    protected boolean containsRaw(int id) {
        return this.objects.containsKey(id);
    }

    protected boolean containsRaw(Identifiable object) {
        return this.objects.contains(object);
    }

    public boolean isErrorOnInitialize() {
        return this.errorOnInitialize;
    }

    public void setErrorOnInitialize(boolean errorOnInitialize) {
        this.errorOnInitialize = errorOnInitialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeIfNecessary() {
        if (!this.initialized) {
            CacheGroup cacheGroup = this;
            synchronized (cacheGroup) {
                if (!this.initialized) {
                    this.initialize();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            this.objectsInOrder = new CopyOnWriteArrayList<T>(this.fetchAllPersistedObjects());
            this.copyOrderedObjectsToMap();
            this.resetHighLowIdentities();
            this.setInitialized(true);
            this.customPostInitialization();
        }
    }

    protected List<T> fetchAllPersistedObjects() {
        return super.list();
    }

    protected void customPostInitialization() {
    }

    protected void copyOrderedObjectsToMap() {
        Iterator<T> iter = this.objectsInOrder.iterator();
        ConcurrentHashMap<Integer, Identifiable> work = new ConcurrentHashMap<Integer, Identifiable>(this.objectsInOrder.size());
        while (iter.hasNext()) {
            Identifiable co = (Identifiable)iter.next();
            work.put(co.getId(), co);
        }
        this.objects = work;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public int lowest() {
        this.calculateHighLowIdentitiesInitial();
        return this.lowestIdentity;
    }

    @Override
    public int highest() {
        this.calculateHighLowIdentitiesInitial();
        return this.highestIdentity;
    }

    protected void resetHighLowIdentities() {
        this.lowestIdentity = Integer.MAX_VALUE;
        this.highestIdentity = 0;
    }

    protected boolean areHighLowIdentitiesInitialized() {
        return this.lowestIdentity < Integer.MAX_VALUE || this.highestIdentity > 0;
    }

    protected void calculateHighLowIdentities() {
        for (Identifiable co : this.objectsInOrder) {
            int id = co.getId();
            if (id < this.lowestIdentity) {
                this.lowestIdentity = id;
            }
            if (id <= this.highestIdentity) continue;
            this.highestIdentity = id;
        }
    }

    protected void calculateHighLowIdentitiesInitial() {
        if (!this.areHighLowIdentitiesInitialized()) {
            this.calculateHighLowIdentities();
        }
    }

    protected void calculateHighLowIdentitiesRecalc() {
        if (this.areHighLowIdentitiesInitialized()) {
            this.calculateHighLowIdentities();
        }
    }

    @Override
    public int size() {
        this.initializeIfNecessary();
        return this.objects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(int ... ids) {
        ConcurrentHashMap<Integer, T> map = this.objects;
        List<T> orderedList = this.objectsInOrder;
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            if (!this.initialized) {
                return;
            }
            TIntObjectMap objectsMap = super.map(CollectionHelper.toList(ids));
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                orderedList.remove(map.remove(id));
                Identifiable object = (Identifiable)objectsMap.get(id);
                if (object != null) {
                    map.put(id, object);
                    int search = Collections.binarySearch(orderedList, object, this.comparator());
                    if (search < 0) {
                        orderedList.add(-search - 1, object);
                    } else {
                        orderedList.add(object);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reorder(int ... ids) {
        ConcurrentHashMap<Integer, T> map = this.objects;
        List<T> orderedList = this.objectsInOrder;
        CacheGroup cacheGroup = this;
        synchronized (cacheGroup) {
            if (!this.initialized) {
                return;
            }
            int[] nArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                Identifiable object = (Identifiable)map.get(id);
                if (object != null) {
                    Identifiable next;
                    int index = orderedList.indexOf(object);
                    Identifiable previous = index == 0 ? null : (Identifiable)orderedList.get(index - 1);
                    Identifiable identifiable = next = index == this.objectsInOrder.size() - 1 ? null : (Identifiable)orderedList.get(index + 1);
                    if (!(previous != null && this.comparator().compare(object, previous) < 0 || next != null && this.comparator().compare(object, next) > 0)) {
                        return;
                    }
                    orderedList.remove(object);
                    int search = Collections.binarySearch(orderedList, object, this.comparator());
                    if (search < 0) {
                        orderedList.add(-search - 1, object);
                    } else {
                        orderedList.add(object);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public String toString() {
        return "CacheGroup [" + this.getType().getSimpleName() + "]";
    }

    @Override
    public void removeAll(Collection<Integer> ids) {
        this.initializeIfNecessary();
        this.removeAllPersistent(ids);
        this.removeFromCache(CollectionHelper.toIntArray(ids));
    }

    protected void removeAllPersistent(Collection<Integer> ids) {
        super.removeAll(ids);
    }

    @Override
    public List<T> list(Collection<Integer> ids) {
        this.initializeIfNecessary();
        ArrayList<Identifiable> theObjects = new ArrayList<Identifiable>(ids.size());
        for (int id : ids) {
            Identifiable object = (Identifiable)this.objects.get(id);
            if (object == null) continue;
            theObjects.add(object);
        }
        return theObjects;
    }

    @Override
    public TIntObjectMap<T> map(Collection<Integer> ids) {
        this.initializeIfNecessary();
        TIntObjectHashMap theObjects = new TIntObjectHashMap(ids.size());
        for (int id : ids) {
            Identifiable object = (Identifiable)this.objects.get(id);
            if (object == null) continue;
            theObjects.put(id, (Object)object);
        }
        return theObjects;
    }

    public static class Builder<T extends Identifiable>
    extends EntityGroup.Builder<T> {
        protected Builder(Class<T> type) {
            super(type);
        }

        @Override
        public CacheGroup<T> build(EntityStore controller) {
            if (controller == null) {
                throw new NullPointerException();
            }
            return new CacheGroup(controller, this.type, this.table, this.id, this.maker, this.comparator, this.where, this.whereArguments);
        }

        @Override
        public Builder<T> table(String tableName) {
            super.table(tableName);
            return this;
        }

        @Override
        public Builder<T> id(String idFieldName) {
            super.id(idFieldName);
            return this;
        }

        @Override
        public Builder<T> maker(EntityMaker<T> entityMaker) {
            super.maker(entityMaker);
            return this;
        }

        @Override
        public Builder<T> comparator(Comparator<? super T> entityComparator) {
            super.comparator(entityComparator);
            return this;
        }

        @Override
        public Builder<T> comparator(String methodName) {
            super.comparator(methodName);
            return this;
        }

        @Override
        public Builder<T> where(String whereClause, String ... arguments) {
            super.where(whereClause, arguments);
            return this;
        }

        @Override
        public Builder<T> constructorArgs(Object ... arguments) {
            super.constructorArgs(arguments);
            return this;
        }
    }
}

