/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.cache;

import com.techempower.gemini.GeminiApplication;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class ResponseCachedToDisk {
    private String requestSignature;
    private int requests;
    private long creationTimeInMillis;
    private long invocationTimeInMillis;
    private File cachedFile;

    private ResponseCachedToDisk() {
    }

    public <G extends GeminiApplication> ResponseCachedToDisk(G app, String requestSignature, String responseText) throws SecurityException, IOException {
        this();
        this.creationTimeInMillis = System.currentTimeMillis();
        this.requestSignature = requestSignature;
        this.requests = 0;
        String fileName = String.valueOf(app.getInfrastructure().getCachedResponseDirectory()) + this.requestSignature.hashCode() + ".html";
        this.cachedFile = new File(fileName);
        if (!this.cachedFile.createNewFile()) {
            this.cachedFile.delete();
            this.cachedFile.createNewFile();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.cachedFile));){
            output.write(responseText.getBytes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.creationTimeInMillis = System.currentTimeMillis() - this.creationTimeInMillis;
    }

    public <G extends GeminiApplication> ResponseCachedToDisk(G app, String requestSignature, String responseText, long invocationTime) throws SecurityException, IOException {
        this(app, requestSignature, responseText);
        this.invocationTimeInMillis = invocationTime;
    }

    public String getRequestSignature() {
        return this.requestSignature;
    }

    public long getCreationTimeInMillis() {
        return this.creationTimeInMillis;
    }

    public int getRequestCount() {
        return this.requests;
    }

    public void setRequestCount(int count) {
        this.requests = count;
    }

    public long getInvocationTimeInMillis() {
        return this.invocationTimeInMillis;
    }

    public void setInvocationTimeInMillis(long invocationTime) {
        this.invocationTimeInMillis = invocationTime;
    }

    public long getFileSize() {
        long toRet = -1L;
        if (this.cachedFile != null && this.cachedFile.exists()) {
            toRet = this.cachedFile.length();
        }
        return toRet;
    }

    public String getFileName() {
        String toRet = "";
        if (this.cachedFile != null && this.cachedFile.exists()) {
            toRet = this.cachedFile.getName();
        }
        return toRet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCachedValue() throws FileNotFoundException {
        byte[] buffer;
        block16: {
            if (this.cachedFile == null) throw new FileNotFoundException("Cached File has been purged.");
            if (!this.cachedFile.exists()) {
                throw new FileNotFoundException("Cached File has been purged.");
            }
            buffer = new byte[(int)this.cachedFile.length()];
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try {
                    FileInputStream fis = new FileInputStream(this.cachedFile);
                    try {
                        try (BufferedInputStream bis = new BufferedInputStream(fis);){
                            bis.read(buffer);
                        }
                        if (fis == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fis == null) throw throwable;
                        fis.close();
                        throw throwable;
                    }
                    fis.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ++this.requests;
        return new String(buffer);
    }

    public boolean represents(String reqSignature) {
        return this.requestSignature.equals(reqSignature);
    }

    public void purge() {
        if (this.cachedFile != null && this.cachedFile.exists()) {
            this.cachedFile.delete();
            this.cachedFile = null;
            try {
                super.finalize();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

