/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection;

import com.techempower.collection.ImmutableNamedValues;
import com.techempower.helper.NumberHelper;
import com.techempower.helper.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ImmutableNamedStrings
implements ImmutableNamedValues {
    private final Map<String, String> values;
    private boolean sealed;

    public ImmutableNamedStrings(Map<String, String> values) {
        this.values = values;
        this.sealed = true;
    }

    public ImmutableNamedStrings(int initialSize) {
        if (initialSize > 0) {
            this.values = new HashMap<String, String>(initialSize);
            this.sealed = false;
        } else {
            this.values = null;
            this.sealed = true;
        }
    }

    public ImmutableNamedStrings seal() {
        this.sealed = true;
        return this;
    }

    public ImmutableNamedStrings put(String name, String value) {
        if (this.sealed) {
            throw new IllegalStateException("This BasicNamedValues is sealed; put is not permitted.");
        }
        this.values.put(name, value);
        return this;
    }

    @Override
    public boolean has(String name) {
        return this.get(name) != null;
    }

    @Override
    public Set<String> names() {
        return this.values.keySet();
    }

    @Override
    public String get(String name) {
        if (this.values == null) {
            return null;
        }
        return this.values.get(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = this.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public int getInt(String name) {
        return NumberHelper.parseInt(this.get(name), 0);
    }

    @Override
    public int getInt(String name, int defaultValue) {
        return NumberHelper.parseInt(this.get(name), defaultValue);
    }

    @Override
    public int getInt(String name, int defaultValue, int minimum, int maximum) {
        return NumberHelper.boundInteger(this.getInt(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name, long defaultValue, long minimum, long maximum) {
        return NumberHelper.boundLong(this.getLong(name, defaultValue), minimum, maximum);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String name, long defaultValue) {
        return NumberHelper.parseLong(this.get(name), defaultValue);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        return StringHelper.parseBoolean(this.get(name), defaultValue);
    }
}

