/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection;

import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import com.techempower.helper.CollectionHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ReflectiveComparator<O>
implements Comparator<O> {
    public static final int BY_FIELD = 1;
    public static final int BY_METHOD = 2;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 1;
    private static final int[] ASCENDING_RETURNS = new int[]{-1, 1};
    private static final int[] DESCENDING_RETURNS = new int[]{1, -1};
    private static final Class<?>[] NO_PARAMETER_LIST = new Class[0];
    private static final Object[] NO_ARGUMENTS = new Object[0];
    private String fieldName;
    private String methodName;
    private FieldAccess fieldAccess = null;
    private int fieldIndex = 0;
    private MethodAccess methodAccess = null;
    private int methodIndex = 0;
    private int comparisonType = 1;
    private int ordering = 0;
    private boolean ignoreCaseOfStrings = false;
    private boolean goodState = true;
    private Map<String, String> memberAliases = null;

    public ReflectiveComparator(String memberName, Class<?> theClass, int comparisonType, int ordering) {
        this.setMemberName(memberName, comparisonType);
        this.setOrdering(ordering);
        this.cacheMemberObject(theClass);
    }

    public ReflectiveComparator(String memberName, Class<?> theClass, int comparisonType, int ordering, String[] aliases, String[] memberNames) {
        this.bindAliases(aliases, memberNames);
        this.setMemberName(memberName, comparisonType);
        this.setOrdering(ordering);
        this.cacheMemberObject(theClass);
    }

    public ReflectiveComparator(String memberName, Class<?> theClass, int comparisonType, int ordering, Map<String, String> aliases) {
        this.bindAliases(aliases);
        this.setMemberName(memberName, comparisonType);
        this.setOrdering(ordering);
        this.cacheMemberObject(theClass);
    }

    public ReflectiveComparator(String memberName, Class<?> theClass, int comparisonType) {
        this(memberName, theClass, comparisonType, 0);
    }

    public ReflectiveComparator(String memberName, Object exampleObject, int comparisonType) {
        this(memberName, exampleObject.getClass(), comparisonType, 0);
    }

    public ReflectiveComparator(String memberName, int comparisonType) {
        this.setMemberName(memberName, comparisonType);
    }

    public ReflectiveComparator(String memberName, int comparisonType, int ordering) {
        this.setMemberName(memberName, comparisonType);
        this.setOrdering(ordering);
    }

    public ReflectiveComparator(String memberName, Class<?> theClass) {
        this(memberName, theClass, 1, 0);
    }

    public ReflectiveComparator(String memberName, Object exampleObject) {
        this(memberName, exampleObject.getClass(), 1, 0);
    }

    public ReflectiveComparator(String memberName) {
        this(memberName, 1);
    }

    public void setIgnoreCase(boolean ignoreCaseOfStrings) {
        this.ignoreCaseOfStrings = ignoreCaseOfStrings;
    }

    public void setOrdering(int ordering) {
        if (ordering == 0 || ordering == 1) {
            this.ordering = ordering;
        }
    }

    public void setMemberName(String memberName, int comparisonType) {
        String aliasedMemberName = this.checkAlias(memberName);
        this.comparisonType = comparisonType;
        if (comparisonType == 2 && !Objects.equals(this.methodName, aliasedMemberName)) {
            this.methodName = aliasedMemberName;
            this.methodAccess = null;
        } else if (!Objects.equals(this.fieldName, aliasedMemberName)) {
            this.fieldName = aliasedMemberName;
            this.fieldAccess = null;
        }
    }

    protected void cacheMemberObject(Class<?> theClass) {
        if (this.comparisonType == 2) {
            this.methodAccess = MethodAccess.get(theClass);
            this.methodIndex = this.methodAccess.getIndex(this.methodName, (Class[])NO_PARAMETER_LIST);
        } else {
            this.fieldAccess = FieldAccess.get(theClass);
            this.fieldIndex = this.fieldAccess.getIndex(this.fieldName);
        }
    }

    @Override
    public int compare(Object object1, Object object2) {
        if (this.comparisonType == 2 && this.methodAccess == null || this.comparisonType == 1 && this.fieldAccess == null) {
            try {
                this.cacheMemberObject(object1.getClass());
            }
            catch (Exception exc) {
                System.out.println("ReflectiveComparator: " + exc);
                this.goodState = false;
            }
        }
        if (this.goodState) {
            Object comparable2;
            Object comparable1;
            if (this.comparisonType == 2) {
                comparable1 = this.methodAccess.invoke(object1, this.methodIndex, NO_ARGUMENTS);
                comparable2 = this.methodAccess.invoke(object2, this.methodIndex, NO_ARGUMENTS);
            } else {
                comparable1 = this.fieldAccess.get(object1, this.fieldIndex);
                comparable2 = this.fieldAccess.get(object2, this.fieldIndex);
            }
            return this.compareTwoObjects(comparable1, comparable2);
        }
        System.out.println("ReflectiveComparator: State is corrupt.  See previous error.");
        return 0;
    }

    public int compareTwoObjects(Object comparable1, Object comparable2) {
        if (comparable1 == null && comparable2 == null) {
            return 0;
        }
        if (comparable1 == null) {
            return DESCENDING_RETURNS[this.ordering];
        }
        if (comparable2 == null) {
            return ASCENDING_RETURNS[this.ordering];
        }
        if (this.ignoreCaseOfStrings && comparable1 instanceof String && comparable2 instanceof String) {
            String string1 = (String)comparable1;
            String string2 = (String)comparable2;
            if (this.ordering == 0) {
                return string1.compareToIgnoreCase(string2);
            }
            return -string1.compareToIgnoreCase(string2);
        }
        if (this.ordering == 0) {
            return ((Comparable)comparable1).compareTo(comparable2);
        }
        return -((Comparable)comparable1).compareTo(comparable2);
    }

    public void bindAliases(String[] aliases, String[] memberNames) {
        HashMap<String, String> newMemberAliases = new HashMap<String, String>(aliases.length);
        int i = 0;
        while (i < aliases.length && i < memberNames.length) {
            newMemberAliases.put(aliases[i], memberNames[i]);
            ++i;
        }
        this.bindAliases(newMemberAliases);
    }

    public void bindAliases(Map<String, String> aliases) {
        if (CollectionHelper.isEmpty(aliases)) {
            this.memberAliases = null;
        }
        this.memberAliases = aliases;
    }

    protected String checkAlias(String name) {
        String actualName;
        if (this.memberAliases != null && (actualName = this.memberAliases.get(name)) != null) {
            return actualName;
        }
        return name;
    }
}

