/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection.relation;

import com.techempower.collection.relation.AbstractIntegerRelation;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.IntegerRelationIterator;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.NoSuchElementException;

public class ManyToOneIntegerRelation
extends AbstractIntegerRelation {
    private final TIntIntMap leftMap = new TIntIntHashMap();
    private final TIntObjectMap<TIntSet> rightMap;
    private int size;

    public ManyToOneIntegerRelation() {
        this(null, true);
    }

    public ManyToOneIntegerRelation(IntegerRelation relation) {
        this(relation, true);
    }

    public ManyToOneIntegerRelation(boolean doublyMapped) {
        this(null, doublyMapped);
    }

    public ManyToOneIntegerRelation(IntegerRelation relation, boolean doublyMapped) {
        this.rightMap = doublyMapped ? new TIntObjectHashMap() : null;
        this.addAll(relation);
    }

    @Override
    public boolean add(int left, int right) {
        if (this.containsLeftValue(left)) {
            return false;
        }
        ++this.size;
        this.leftMap.put(left, right);
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            if (leftSet == null) {
                leftSet = new TIntHashSet();
                this.rightMap.put(right, (Object)leftSet);
            }
            leftSet.add(left);
        }
        return true;
    }

    @Override
    public void clear() {
        this.leftMap.clear();
        if (this.rightMap != null) {
            this.rightMap.clear();
        }
        this.size = 0;
    }

    @Override
    public Object clone() {
        return new ManyToOneIntegerRelation(this, this.rightMap != null);
    }

    @Override
    public boolean contains(int left, int right) {
        return this.leftMap.containsKey(left) && this.leftMap.get(left) == right;
    }

    @Override
    public boolean containsLeftValue(int left) {
        return this.leftMap.containsKey(left);
    }

    @Override
    public boolean containsRightValue(int right) {
        if (this.rightMap != null) {
            return this.rightMap.containsKey(right);
        }
        return this.leftMap.containsValue(right);
    }

    @Override
    public int leftSize(int right) {
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            return leftSet == null ? 0 : leftSet.size();
        }
        int computedSize = 0;
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            ++computedSize;
        }
        return computedSize;
    }

    @Override
    public int[] leftValues(int right) {
        if (this.rightMap != null) {
            TIntSet leftSet = (TIntSet)this.rightMap.get(right);
            if (leftSet != null) {
                int[] leftArray = new int[leftSet.size()];
                leftSet.toArray(leftArray);
                return leftArray;
            }
            return new int[0];
        }
        TIntHashSet leftSet = new TIntHashSet();
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            leftSet.add(iter.key());
        }
        return leftSet.toArray();
    }

    @Override
    public boolean remove(int left, int right) {
        TIntSet leftSet;
        if (!this.contains(left, right)) {
            return false;
        }
        --this.size;
        this.leftMap.remove(left);
        if (this.rightMap != null && (leftSet = (TIntSet)this.rightMap.get(right)) != null) {
            leftSet.remove(left);
            if (leftSet.isEmpty()) {
                this.rightMap.remove(right);
            }
        }
        return true;
    }

    @Override
    public boolean removeLeftValue(int left) {
        if (!this.containsLeftValue(left)) {
            return false;
        }
        --this.size;
        this.leftMap.remove(left);
        if (this.rightMap != null) {
            TIntObjectIterator iter = this.rightMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                ((TIntSet)iter.value()).remove(left);
                if (!((TIntSet)iter.value()).isEmpty()) continue;
                iter.remove();
            }
        }
        return true;
    }

    @Override
    public boolean removeRightValue(int right) {
        if (!this.containsRightValue(right)) {
            return false;
        }
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            iter.remove();
            --this.size;
        }
        if (this.rightMap != null) {
            this.rightMap.remove(right);
        }
        return true;
    }

    @Override
    public int rightSize(int left) {
        return this.leftMap.containsKey(left) ? 1 : 0;
    }

    @Override
    public int[] rightValues(int left) {
        if (this.leftMap.containsKey(left)) {
            return new int[]{this.leftMap.get(left)};
        }
        return new int[0];
    }

    @Override
    public TIntSet rightValuesIntegerSet(int left) {
        if (this.leftMap.containsKey(left)) {
            return new TIntHashSet(this.leftMap.get(left));
        }
        return new TIntHashSet(0);
    }

    @Override
    public IntegerRelationIterator iterator() {
        return new IntegerRelationIterator(){
            private boolean start = false;
            private int left = 0;
            private int right = 0;
            private TIntIntIterator mapIterator;
            {
                this.mapIterator = ManyToOneIntegerRelation.this.leftMap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public int left() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.left;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
                }
                this.start = true;
                this.mapIterator.advance();
                this.left = this.mapIterator.key();
                this.right = this.mapIterator.value();
            }

            @Override
            public int right() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.right;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

