/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.collection.relation;

import com.techempower.collection.relation.AbstractIntegerRelation;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.IntegerRelationIterator;
import gnu.trove.iterator.TIntIntIterator;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.NoSuchElementException;

public class OneToOneIntegerRelation
extends AbstractIntegerRelation {
    private final TIntIntMap leftMap = new TIntIntHashMap();
    private final TIntIntMap rightMap;
    private int size;

    public OneToOneIntegerRelation() {
        this(null, false);
    }

    public OneToOneIntegerRelation(IntegerRelation relation) {
        this(relation, false);
    }

    public OneToOneIntegerRelation(boolean doublyMapped) {
        this(null, doublyMapped);
    }

    public OneToOneIntegerRelation(IntegerRelation relation, boolean doublyMapped) {
        this.rightMap = doublyMapped ? new TIntIntHashMap() : null;
        this.addAll(relation);
    }

    @Override
    public boolean add(int left, int right) {
        if (this.containsLeftValue(left) || this.containsRightValue(right)) {
            return false;
        }
        ++this.size;
        this.leftMap.put(left, right);
        if (this.rightMap != null) {
            this.rightMap.put(right, left);
        }
        return true;
    }

    @Override
    public void clear() {
        this.leftMap.clear();
        if (this.rightMap != null) {
            this.rightMap.clear();
        }
        this.size = 0;
    }

    @Override
    public Object clone() {
        return new OneToOneIntegerRelation(this, this.rightMap != null);
    }

    @Override
    public boolean contains(int left, int right) {
        return this.leftMap.containsKey(left) && this.leftMap.get(left) == right;
    }

    @Override
    public boolean containsLeftValue(int left) {
        return this.leftMap.containsKey(left);
    }

    @Override
    public boolean containsRightValue(int right) {
        if (this.rightMap != null) {
            return this.rightMap.containsKey(right);
        }
        return this.leftMap.containsValue(right);
    }

    @Override
    public int leftSize(int right) {
        if (this.rightMap != null) {
            return this.rightMap.containsKey(right) ? 1 : 0;
        }
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int[] leftValues(int right) {
        if (this.rightMap != null) {
            if (this.rightMap.containsKey(right)) {
                return new int[]{this.rightMap.get(right)};
            }
            return new int[0];
        }
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            return new int[]{iter.key()};
        }
        return new int[0];
    }

    @Override
    public boolean remove(int left, int right) {
        if (!this.contains(left, right)) {
            return false;
        }
        --this.size;
        this.leftMap.remove(left);
        if (this.rightMap != null) {
            this.rightMap.remove(right);
        }
        return true;
    }

    @Override
    public boolean removeLeftValue(int left) {
        if (!this.containsLeftValue(left)) {
            return false;
        }
        --this.size;
        this.leftMap.remove(left);
        if (this.rightMap != null) {
            TIntIntIterator iter = this.rightMap.iterator();
            while (iter.hasNext()) {
                iter.advance();
                if (iter.value() != left) continue;
                iter.remove();
            }
        }
        return true;
    }

    @Override
    public boolean removeRightValue(int right) {
        if (!this.containsRightValue(right)) {
            return false;
        }
        --this.size;
        TIntIntIterator iter = this.leftMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            if (iter.value() != right) continue;
            iter.remove();
        }
        if (this.rightMap != null) {
            this.rightMap.remove(right);
        }
        return true;
    }

    @Override
    public int rightSize(int left) {
        return this.leftMap.containsKey(left) ? 1 : 0;
    }

    @Override
    public int[] rightValues(int left) {
        if (this.leftMap.containsKey(left)) {
            return new int[]{this.leftMap.get(left)};
        }
        return new int[0];
    }

    @Override
    public TIntSet rightValuesIntegerSet(int left) {
        if (this.leftMap.containsKey(left)) {
            return new TIntHashSet(this.leftMap.get(left));
        }
        return new TIntHashSet(0);
    }

    @Override
    public IntegerRelationIterator iterator() {
        return new IntegerRelationIterator(){
            private boolean start = false;
            private int left = 0;
            private int right = 0;
            private TIntIntIterator mapIterator;
            {
                this.mapIterator = OneToOneIntegerRelation.this.leftMap.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mapIterator.hasNext();
            }

            @Override
            public int left() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.left;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
                }
                this.mapIterator.advance();
                this.left = this.mapIterator.key();
                this.right = this.mapIterator.value();
                this.start = true;
            }

            @Override
            public int right() {
                if (!this.start) {
                    throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
                }
                return this.right;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }
}

