/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data;

import com.techempower.asynchronous.Asynchronous;
import com.techempower.data.ConnectorFactory;
import com.techempower.gemini.GeminiApplication;
import com.techempower.log.ComponentLog;
import com.techempower.thread.EndableThread;
import com.techempower.util.Identifiable;
import java.util.concurrent.ConcurrentLinkedQueue;

public class EntityUpdater
implements Asynchronous {
    public static final String COMPONENT_CODE = "entu";
    private final GeminiApplication application;
    private final ComponentLog log;
    private final ConcurrentLinkedQueue<Identifiable> queue = new ConcurrentLinkedQueue();
    private final EntityUpdaterThread thread;
    private int threadPriority = 5;
    private int totalUpdateCount = 0;

    public EntityUpdater(GeminiApplication application, ConnectorFactory factory) {
        this.application = application;
        this.log = application.getLog(COMPONENT_CODE);
        this.thread = new EntityUpdaterThread();
        application.addAsynchronous(this);
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        if (this.thread != null) {
            this.thread.setPriority(threadPriority);
        }
    }

    @Override
    public void begin() {
        this.thread.setName("Entity Updater Thread (" + this.application.getVersion().getProductName() + ")");
        this.thread.setPriority(this.threadPriority);
        this.log.log("Starting entity updater thread.", 10);
        this.thread.begin();
    }

    @Override
    public void end() {
        this.stopThread();
        this.flushQueue();
    }

    protected void stopThread() {
        this.log.log("Stopping entity updater thread.", 10);
        this.thread.setKeepRunning(false);
    }

    protected int flushQueue() {
        int updateCount = 0;
        while (this.queue.peek() != null) {
            Identifiable entity = this.queue.poll();
            this.application.getStore().put(entity);
            ++updateCount;
        }
        return updateCount;
    }

    public void add(Identifiable entity) {
        if (!this.queue.contains(entity)) {
            this.queue.add(entity);
        }
    }

    public int getUpdateCount() {
        return this.totalUpdateCount;
    }

    public String toString() {
        return "EntityUpdater (" + this.getUpdateCount() + " updates)";
    }

    class EntityUpdaterThread
    extends EndableThread {
        public EntityUpdaterThread() {
            super("Entity Updater Thread", 10000, 60000, 5000, 5000);
        }

        @Override
        public void run() {
            this.setStartTime();
            while (this.checkPause()) {
                int updated = 0;
                try {
                    updated = EntityUpdater.this.flushQueue();
                }
                catch (Exception exc) {
                    EntityUpdater.this.log.log("Exception while flushing entity updater queue", exc);
                    exc.printStackTrace();
                }
                if (updated > 0) {
                    EntityUpdater entityUpdater = EntityUpdater.this;
                    entityUpdater.totalUpdateCount = entityUpdater.totalUpdateCount + updated;
                    this.setMinimumSleep();
                } else {
                    this.incrementSleep();
                }
                this.simpleSleep();
            }
        }
    }
}

