/*
 * Decompiled with CFR 0.152.
 */
package com.techempower.data;

import com.techempower.cache.EntityStore;
import com.techempower.collection.relation.IntegerRelation;
import com.techempower.collection.relation.ManyToManyIntegerRelation;
import com.techempower.data.ConnectionMonitor;
import com.techempower.data.ConnectorFactory;
import com.techempower.data.DatabaseAffinity;
import com.techempower.data.EntityException;
import com.techempower.data.EntityRelation;
import com.techempower.helper.DatabaseHelper;
import com.techempower.helper.StringHelper;
import com.techempower.util.Identifiable;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class SqlEntityRelation<L extends Identifiable, R extends Identifiable>
implements EntityRelation<L, R> {
    private static final int MAX_SQL_SIZE = 1000;
    private final EntityStore store;
    private final ConnectorFactory cf;
    private final Class<L> leftType;
    private final Class<R> rightType;
    private final String table;
    private final String leftColumn;
    private final String rightColumn;
    private final String quotedTable;
    private final String quotedLeftColumn;
    private final String quotedRightColumn;

    public static <L extends Identifiable, R extends Identifiable> Builder<L, R> of(Class<L> leftType, Class<R> rightType) {
        return new Builder<L, R>(leftType, rightType);
    }

    protected SqlEntityRelation(EntityStore store, Class<L> leftType, Class<R> rightType, String tableName, String leftColumn, String rightColumn) {
        this.store = store;
        this.cf = store.getConnectorFactory();
        this.leftType = leftType;
        this.rightType = rightType;
        this.table = tableName == null ? "map" + leftType.getSimpleName().toLowerCase() + "to" + rightType.getSimpleName().toLowerCase() : tableName;
        this.leftColumn = leftColumn == null ? leftType.getSimpleName().toLowerCase() : leftColumn;
        this.rightColumn = rightColumn == null ? rightType.getSimpleName().toLowerCase() : rightColumn;
        this.quotedTable = DatabaseHelper.quoteTableOrColumn(this.cf, this.table);
        this.quotedLeftColumn = DatabaseHelper.quoteTableOrColumn(this.cf, this.leftColumn);
        this.quotedRightColumn = DatabaseHelper.quoteTableOrColumn(this.cf, this.rightColumn);
    }

    private String newInsertStatement(int insertCount) {
        if (insertCount < 1) {
            throw new IllegalArgumentException("Argument 'insertCount' must be greater than zero.");
        }
        String insertKeyword = this.cf.getDatabaseAffinity() == DatabaseAffinity.MS_SQL_SERVER ? "INSERT" : "INSERT IGNORE";
        String questionMarks = insertCount == 1 ? "(?,?)" : StringHelper.join(",", Collections.nCopies(insertCount, "(?,?)"));
        return String.valueOf(insertKeyword) + " INTO " + this.quotedTable + " (" + this.quotedLeftColumn + ", " + this.quotedRightColumn + ") VALUES " + questionMarks + ";";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean add(int leftID, int rightID) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement insertStatement = monitor.getConnection().prepareStatement(this.newInsertStatement(1));
                        try {
                            insertStatement.setInt(1, leftID);
                            insertStatement.setInt(2, rightID);
                            if (insertStatement.executeUpdate() > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (insertStatement == null) break block17;
                            insertStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean add(int leftID, R right) {
        return right != null && this.add(leftID, right.getId());
    }

    @Override
    public boolean add(L left, int rightID) {
        return left != null && this.add(left.getId(), rightID);
    }

    @Override
    public boolean add(L left, R right) {
        return left != null && right != null && this.add(left.getId(), right.getId());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean addAll(IntegerRelation relationToAdd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void clear() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    try (PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + ";");){
                        deleteStatement.executeUpdate();
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(int leftID, int rightID) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ? AND " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            selectStatement.setInt(2, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            if (resultSet.getInt("count") > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (selectStatement == null) break block17;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean contains(int leftID, R right) {
        return right != null && this.contains(leftID, right.getId());
    }

    @Override
    public boolean contains(L left, int rightID) {
        return left != null && this.contains(left.getId(), rightID);
    }

    @Override
    public boolean contains(L left, R right) {
        return left != null && right != null && this.contains(left.getId(), right.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsLeftValue(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            if (resultSet.getInt("count") > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (selectStatement == null) break block17;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean containsLeftValue(L left) {
        return left != null && this.containsLeftValue(left.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsRightValue(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            if (resultSet.getInt("count") > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (selectStatement == null) break block17;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean containsRightValue(R right) {
        return right != null && this.containsRightValue(right.getId());
    }

    @Override
    public int[] leftIDArray(R right) {
        return right == null ? new int[]{} : this.leftIDArray(right.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] leftIDArray(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int[] nArray;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            TIntHashSet leftIDs = new TIntHashSet();
                            while (true) {
                                if (!resultSet.next()) {
                                    nArray = leftIDs.toArray();
                                    return nArray;
                                }
                                leftIDs.add(resultSet.getInt(this.leftColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return nArray;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Integer> leftIDs(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                HashSet<Integer> hashSet;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> leftIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    hashSet = leftIDs;
                                    return hashSet;
                                }
                                leftIDs.add(resultSet.getInt(this.leftColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return hashSet;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public Set<Integer> leftIDs(R right) {
        return right == null ? new HashSet(0) : this.leftIDs((R)right.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int leftSize(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int n;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block16: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            n = resultSet.getInt("count");
                            return n;
                        }
                        finally {
                            if (selectStatement == null) break block16;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return n;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public int leftSize(R right) {
        return right == null ? 0 : this.leftSize(right.getId());
    }

    @Override
    public Class<L> leftType() {
        return this.leftType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<L> leftValueList(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                List<L> list;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> leftIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    list = this.store.list(this.leftType, leftIDs);
                                    return list;
                                }
                                leftIDs.add(resultSet.getInt(this.leftColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return list;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public List<L> leftValueList(R right) {
        return right == null ? new ArrayList(0) : this.leftValueList((R)right.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<L> leftValueSet(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                HashSet<L> hashSet;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, rightID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> leftIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    hashSet = new HashSet<L>(this.store.list(this.leftType, leftIDs));
                                    return hashSet;
                                }
                                leftIDs.add(resultSet.getInt(this.leftColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return hashSet;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public Set<L> leftValueSet(R right) {
        return right == null ? new HashSet(0) : this.leftValueSet((R)right.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IntegerRelation relation() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                ManyToManyIntegerRelation manyToManyIntegerRelation;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedLeftColumn + ", " + this.quotedRightColumn + " FROM " + this.quotedTable + ";", 1003, 1007);
                        try {
                            ResultSet resultSet = selectStatement.executeQuery();
                            ManyToManyIntegerRelation relation = new ManyToManyIntegerRelation();
                            while (true) {
                                if (!resultSet.next()) {
                                    manyToManyIntegerRelation = relation;
                                    return manyToManyIntegerRelation;
                                }
                                relation.add(resultSet.getInt(this.leftColumn), resultSet.getInt(this.rightColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return manyToManyIntegerRelation;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean remove(int leftID, int rightID) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ? AND " + this.quotedRightColumn + " = ?;");
                        try {
                            deleteStatement.setInt(1, leftID);
                            deleteStatement.setInt(2, rightID);
                            if (deleteStatement.executeUpdate() > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (deleteStatement == null) break block17;
                            deleteStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean remove(int leftID, R right) {
        return right != null && this.remove(leftID, right.getId());
    }

    @Override
    public boolean remove(L left, int rightID) {
        return left != null && this.remove(left.getId(), rightID);
    }

    @Override
    public boolean remove(L left, R right) {
        return left != null && right != null && this.remove(left.getId(), right.getId());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean removeAll(IntegerRelation relationToRemove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public <T extends Identifiable> boolean removeEntity(T object) {
        return object == null ? false : this.removeEntity(object.getClass(), object.getId());
    }

    @Override
    public <T extends Identifiable> boolean removeEntity(Class<T> type, int idToRemove) {
        boolean changed = false;
        if (this.leftType == type) {
            boolean bl = changed = this.removeLeftValue(idToRemove) || changed;
        }
        if (this.rightType == type) {
            changed = this.removeRightValue(idToRemove) || changed;
        }
        return changed;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeLeftValue(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;");
                        try {
                            deleteStatement.setInt(1, leftID);
                            if (deleteStatement.executeUpdate() > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (deleteStatement == null) break block17;
                            deleteStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean removeLeftValue(L left) {
        return left != null && this.removeLeftValue(left.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean removeRightValue(int rightID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                boolean bl;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block17: {
                        PreparedStatement deleteStatement = monitor.getConnection().prepareStatement("DELETE FROM " + this.quotedTable + " WHERE " + this.quotedRightColumn + " = ?;");
                        try {
                            deleteStatement.setInt(1, rightID);
                            if (deleteStatement.executeUpdate() > 0) {
                                bl = true;
                            }
                            bl = false;
                            return bl;
                        }
                        finally {
                            if (deleteStatement == null) break block17;
                            deleteStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return bl;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public boolean removeRightValue(R right) {
        return right != null && this.removeRightValue(right.getId());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean replaceAll(IntegerRelation relationToReplace) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int[] rightIDArray(L left) {
        return left == null ? new int[]{} : this.rightIDArray(left.getId());
    }

    @Override
    public int[] rightIDArray(int leftID) {
        return this.rightIDsIntegerSet(leftID).toArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TIntSet rightIDsIntegerSet(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                TIntHashSet tIntHashSet;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedRightColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            TIntHashSet rightIDsIntegerSet = new TIntHashSet();
                            while (true) {
                                if (!resultSet.next()) {
                                    tIntHashSet = rightIDsIntegerSet;
                                    return tIntHashSet;
                                }
                                rightIDsIntegerSet.add(resultSet.getInt(this.rightColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return tIntHashSet;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Integer> rightIDs(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                HashSet<Integer> hashSet;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedRightColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> rightIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    hashSet = rightIDs;
                                    return hashSet;
                                }
                                rightIDs.add(resultSet.getInt(this.rightColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return hashSet;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public Set<Integer> rightIDs(L left) {
        return left == null ? new HashSet(0) : this.rightIDs((L)left.getId());
    }

    @Override
    public TIntSet rightIDsIntegerSet(L left) {
        return left == null ? new TIntHashSet(0) : this.rightIDsIntegerSet(left.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int rightSize(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                int n;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block16: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            n = resultSet.getInt("count");
                            return n;
                        }
                        finally {
                            if (selectStatement == null) break block16;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return n;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public int rightSize(L left) {
        return left == null ? 0 : this.rightSize(left.getId());
    }

    @Override
    public int rightSize(L left, Collection<Integer> filterRightIds) {
        return left == null ? 0 : this.rightSize(left.getId(), filterRightIds);
    }

    @Override
    public int rightSize(L left, TIntSet filterRightIds) {
        return left == null ? 0 : this.rightSize(left.getId(), filterRightIds);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int rightSize(int leftID, Collection<Integer> filterRightIds) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                int n;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ? AND " + this.quotedRightColumn + " IN (" + StringHelper.join(",", Collections.nCopies(filterRightIds.size(), "?")) + ");", 1003, 1007);
                        try {
                            int index = 0;
                            selectStatement.setInt(++index, leftID);
                            Iterator<Integer> iterator = filterRightIds.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    ResultSet resultSet = selectStatement.executeQuery();
                                    resultSet.next();
                                    n = resultSet.getInt("count");
                                    return n;
                                }
                                int rightID = iterator.next();
                                selectStatement.setInt(++index, rightID);
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return n;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int rightSize(int leftID, TIntSet filterRightIds) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                int n;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ? AND " + this.quotedRightColumn + " IN (" + StringHelper.join(",", Collections.nCopies(filterRightIds.size(), "?")) + ");", 1003, 1007);
                        try {
                            int index = 0;
                            selectStatement.setInt(++index, leftID);
                            TIntIterator iterator = filterRightIds.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    ResultSet resultSet = selectStatement.executeQuery();
                                    resultSet.next();
                                    n = resultSet.getInt("count");
                                    return n;
                                }
                                selectStatement.setInt(++index, iterator.next());
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return n;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public Class<R> rightType() {
        return this.rightType;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<R> rightValueList(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                List<R> list;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedRightColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> rightIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    list = this.store.list(this.rightType, rightIDs);
                                    return list;
                                }
                                rightIDs.add(resultSet.getInt(this.rightColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return list;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public List<R> rightValueList(L left) {
        return left == null ? new ArrayList(0) : this.rightValueList((L)left.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<R> rightValueSet(int leftID) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                HashSet<R> hashSet;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block18: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT " + this.quotedRightColumn + " FROM " + this.quotedTable + " WHERE " + this.quotedLeftColumn + " = ?;", 1003, 1007);
                        try {
                            selectStatement.setInt(1, leftID);
                            ResultSet resultSet = selectStatement.executeQuery();
                            HashSet<Integer> rightIDs = new HashSet<Integer>();
                            while (true) {
                                if (!resultSet.next()) {
                                    hashSet = new HashSet<R>(this.store.list(this.rightType, rightIDs));
                                    return hashSet;
                                }
                                rightIDs.add(resultSet.getInt(this.rightColumn));
                            }
                        }
                        finally {
                            if (selectStatement == null) break block18;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return hashSet;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public Set<R> rightValueSet(L left) {
        return left == null ? new HashSet(0) : this.rightValueSet((L)left.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int size() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                int n;
                ConnectionMonitor monitor = this.cf.getConnectionMonitor();
                try {
                    block16: {
                        PreparedStatement selectStatement = monitor.getConnection().prepareStatement("SELECT COUNT(*) AS 'count' FROM " + this.quotedTable + ";", 1003, 1007);
                        try {
                            ResultSet resultSet = selectStatement.executeQuery();
                            resultSet.next();
                            n = resultSet.getInt("count");
                            return n;
                        }
                        finally {
                            if (selectStatement == null) break block16;
                            selectStatement.close();
                        }
                    }
                    if (monitor != null) {
                        monitor.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (monitor == null) throw throwable;
                    monitor.close();
                    throw throwable;
                }
                {
                    return n;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new EntityException(e);
        }
    }

    @Override
    public String tableName() {
        return this.table;
    }

    public static class Builder<L extends Identifiable, R extends Identifiable>
    implements EntityRelation.Builder<L, R, SqlEntityRelation<L, R>> {
        private final Class<L> leftType;
        private final Class<R> rightType;
        private String table;
        private String leftColumn;
        private String rightColumn;

        protected Builder(Class<L> leftType, Class<R> rightType) {
            Objects.requireNonNull(leftType);
            Objects.requireNonNull(rightType);
            this.leftType = leftType;
            this.rightType = rightType;
        }

        @Override
        public SqlEntityRelation<L, R> build(EntityStore store) {
            Objects.requireNonNull(store);
            return new SqlEntityRelation<L, R>(store, this.leftType, this.rightType, this.table, this.leftColumn, this.rightColumn);
        }

        public Builder<L, R> table(String tableName) {
            Objects.requireNonNull(tableName);
            this.table = tableName;
            return this;
        }

        public Builder<L, R> leftColumn(String leftColumnName) {
            Objects.requireNonNull(leftColumnName);
            this.leftColumn = leftColumnName;
            return this;
        }

        public Builder<L, R> rightColumn(String rightColumnName) {
            Objects.requireNonNull(rightColumnName);
            this.rightColumn = rightColumnName;
            return this;
        }
    }
}

